/*
 * Decompiled with CFR 0.152.
 */
package org.raystack.stencil.client;

import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.raystack.stencil.cache.SchemaCacheLoader;
import org.raystack.stencil.client.StencilClient;
import org.raystack.stencil.client.URLStencilClient;
import org.raystack.stencil.config.StencilConfig;

public class MultiURLStencilClient
implements Serializable,
StencilClient {
    private List<StencilClient> stencilClients;

    public MultiURLStencilClient(List<String> urls, StencilConfig config, SchemaCacheLoader cacheLoader) {
        this.stencilClients = urls.stream().map(url -> new URLStencilClient((String)url, config, cacheLoader)).collect(Collectors.toList());
    }

    @Override
    public Descriptors.Descriptor get(String protoClassName) {
        Optional<StencilClient> requiredStencil = this.stencilClients.stream().filter(stencilClient -> stencilClient.get(protoClassName) != null).findFirst();
        return requiredStencil.map(stencilClient -> stencilClient.get(protoClassName)).orElse(null);
    }

    @Override
    public Map<String, Descriptors.Descriptor> getAll() {
        HashMap<String, Descriptors.Descriptor> requiredStencil = new HashMap<String, Descriptors.Descriptor>();
        this.stencilClients.stream().map(StencilClient::getAll).forEach(requiredStencil::putAll);
        return requiredStencil;
    }

    @Override
    public void close() {
        this.stencilClients.forEach(c -> {
            try {
                c.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void refresh() {
        this.stencilClients.forEach(c -> c.refresh());
    }
}

