/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.rcsb.cif.EncodingStrategyHint;

public class CifOptions {
    private final boolean gzip;
    private final String encoder;
    private final String fetchUrl;
    private final List<String> categoryWhitelist;
    private final List<String> categoryBlacklist;
    private final List<String> columnWhitelist;
    private final List<String> columnBlacklist;
    private final List<EncodingStrategyHint> encodingStrategyHints;
    private final CifOptionsBuilder.FileFormat fileFormat;

    private CifOptions(CifOptionsBuilder builder) {
        this.gzip = builder.gzip;
        this.encoder = builder.encoder;
        this.fetchUrl = builder.fetchUrl;
        this.categoryWhitelist = builder.categoryWhitelist;
        this.categoryBlacklist = builder.categoryBlacklist;
        this.columnWhitelist = builder.columnWhitelist;
        this.columnBlacklist = builder.columnBlacklist;
        this.fileFormat = builder.fileFormat;
        List categoriesToAdd = this.columnWhitelist.stream().map(fullColumnName -> fullColumnName.split("\\.")[0]).distinct().filter(categoryName -> !this.columnWhitelist.contains(categoryName)).collect(Collectors.toList());
        this.categoryWhitelist.addAll(categoriesToAdd);
        this.encodingStrategyHints = builder.encodingStrategyHints;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public String getEncoder() {
        return this.encoder;
    }

    public String getFetchUrl() {
        return this.fetchUrl;
    }

    public boolean filterCategory(String categoryName) {
        if (this.categoryBlacklist.contains(categoryName)) {
            return false;
        }
        return this.categoryWhitelist.size() <= 0 || this.categoryWhitelist.contains(categoryName);
    }

    public boolean filterColumn(String categoryName, String columnName) {
        String fullColumnName = categoryName + "." + columnName;
        if (this.columnBlacklist.contains(fullColumnName)) {
            return false;
        }
        return this.columnWhitelist.stream().noneMatch(fcn -> fcn.split("\\.")[0].equals(categoryName)) || this.columnWhitelist.contains(fullColumnName);
    }

    public Optional<EncodingStrategyHint> getEncodingStrategyHint(String categoryName, String columnName) {
        return this.encodingStrategyHints.stream().filter(encodingStrategyHint -> encodingStrategyHint.getCategoryName().equals(categoryName) && encodingStrategyHint.getColumnName().equals(columnName)).findFirst();
    }

    public CifOptionsBuilder.FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public static CifOptionsBuilder builder() {
        return new CifOptionsBuilder();
    }

    public static class CifOptionsBuilder {
        private static final String FETCH_URL = "https://models.rcsb.org/%s.bcif";
        private boolean generic = false;
        private boolean gzip = false;
        private String encoder = "ciftools-java";
        private String fetchUrl = "https://models.rcsb.org/%s.bcif";
        private final List<String> categoryWhitelist = new ArrayList<String>();
        private final List<String> categoryBlacklist = new ArrayList<String>();
        private final List<String> columnWhitelist = new ArrayList<String>();
        private final List<String> columnBlacklist = new ArrayList<String>();
        private final List<EncodingStrategyHint> encodingStrategyHints = new ArrayList<EncodingStrategyHint>();
        private FileFormat fileFormat;

        public CifOptionsBuilder gzip(boolean gzip) {
            this.gzip = gzip;
            return this;
        }

        public CifOptionsBuilder encoder(String encoder) {
            this.encoder = encoder;
            return this;
        }

        public CifOptionsBuilder fetchUrl(String fetchUrl) {
            this.fetchUrl = fetchUrl;
            return this;
        }

        public CifOptionsBuilder categoryWhitelist(String ... categoryWhitelist) {
            return this.categoryWhitelist(Arrays.asList(categoryWhitelist));
        }

        public CifOptionsBuilder categoryWhitelist(List<String> categoryWhitelist) {
            this.categoryWhitelist.addAll(categoryWhitelist);
            return this;
        }

        public CifOptionsBuilder categoryBlacklist(String ... categoryBlacklist) {
            return this.categoryBlacklist(Arrays.asList(categoryBlacklist));
        }

        public CifOptionsBuilder categoryBlacklist(List<String> categoryBlacklist) {
            this.categoryBlacklist.addAll(categoryBlacklist);
            return this;
        }

        public CifOptionsBuilder columnWhitelist(String ... columnWhitelist) {
            return this.columnWhitelist(Arrays.asList(columnWhitelist));
        }

        public CifOptionsBuilder columnWhitelist(List<String> columnWhitelist) {
            this.columnWhitelist.addAll(columnWhitelist);
            return this;
        }

        public CifOptionsBuilder columnBlacklist(String ... columnBlacklist) {
            return this.columnBlacklist(Arrays.asList(columnBlacklist));
        }

        public CifOptionsBuilder columnBlacklist(List<String> columnBlacklist) {
            this.columnBlacklist.addAll(columnBlacklist);
            return this;
        }

        public CifOptionsBuilder encodingStrategyHint(Path path) {
            CifOptionsBuilder cifOptionsBuilder;
            block8: {
                BufferedReader bufferedReader = Files.newBufferedReader(path);
                try {
                    cifOptionsBuilder = this.encodingStrategyHint(bufferedReader.lines().collect(Collectors.joining()));
                    if (bufferedReader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                bufferedReader.close();
            }
            return cifOptionsBuilder;
        }

        public CifOptionsBuilder encodingStrategyHint(String json) {
            this.encodingStrategyHints.addAll((Collection)GsonHolder.instance.fromJson(json, ListTypeHolder.instance));
            return this;
        }

        public CifOptionsBuilder encodingStrategyHint(String categoryName, String columnName, String encoding, int precision) {
            this.encodingStrategyHints.add(new EncodingStrategyHint(categoryName, columnName, encoding, precision));
            return this;
        }

        public CifOptionsBuilder encodingStrategyHint(EncodingStrategyHint ... encodingStrategyHints) {
            return this.encodingStrategyHint(Arrays.asList(encodingStrategyHints));
        }

        public CifOptionsBuilder encodingStrategyHint(List<EncodingStrategyHint> encodingStrategyHints) {
            this.encodingStrategyHints.addAll(encodingStrategyHints);
            return this;
        }

        public CifOptionsBuilder fileFormatHint(FileFormat fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public CifOptions build() {
            return new CifOptions(this);
        }

        public static enum FileFormat {
            BCIF_PLAIN,
            BCIF_GZIPPED,
            CIF_PLAIN,
            CIF_GZIPPED;

        }

        static class GsonHolder {
            static final Gson instance = new Gson();

            GsonHolder() {
            }
        }

        static class ListTypeHolder {
            static final Type instance = new TypeToken<ArrayList<EncodingStrategyHint>>(){}.getType();

            ListTypeHolder() {
            }
        }
    }
}

