/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.rcsb.cif.EncodingStrategyHint;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.Float64Array;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.IntArray;
import org.rcsb.cif.binary.encoding.DeltaEncoding;
import org.rcsb.cif.binary.encoding.IntegerPackingEncoding;
import org.rcsb.cif.binary.encoding.RunLengthEncoding;

public class Classifier {
    private static final double DELTA = 1.0E-6;

    public static EncodingStrategyHint classify(Int32Array data) {
        EncodingStrategyHint hint = new EncodingStrategyHint();
        if (data.getData().length < 2) {
            hint.setEncoding("byte");
            return hint;
        }
        EncodingSize size = Classifier.getSize(data);
        hint.setEncoding(size.kind);
        return hint;
    }

    private static int packSize(int value, int upperLimit) {
        return (int)Math.ceil((double)(value + 1) / (double)(value >= 0 ? upperLimit : -upperLimit - 1));
    }

    public static ByteArray encode(Int32Array column, String encoding) {
        switch (encoding) {
            case "byte": {
                return column.encode();
            }
            case "pack": {
                return column.encode(new IntegerPackingEncoding()).encode();
            }
            case "rle": {
                return column.encode(new RunLengthEncoding()).encode(new IntegerPackingEncoding()).encode();
            }
            case "delta": {
                return ((Int32Array)column.encode(new DeltaEncoding())).encode(new IntegerPackingEncoding()).encode();
            }
            case "delta-rle": {
                return column.encode(new DeltaEncoding()).encode(new RunLengthEncoding()).encode(new IntegerPackingEncoding()).encode();
            }
        }
        throw new IllegalArgumentException("Determined encoding type is unknown. " + encoding);
    }

    private static void incSize(IntColumnInfo intColumnInfo, SizeInfo sizeInfo, int value) {
        sizeInfo.pack8 += Classifier.packSize(value, intColumnInfo.limit8);
        sizeInfo.pack16 += Classifier.packSize(value, intColumnInfo.limit16);
        ++sizeInfo.count;
    }

    private static void incSizeSigned(SizeInfo sizeInfo, int value) {
        sizeInfo.pack8 += Classifier.packSize(value, 127);
        sizeInfo.pack16 += Classifier.packSize(value, Short.MAX_VALUE);
        ++sizeInfo.count;
    }

    private static ByteSize byteSize(SizeInfo sizeInfo) {
        if (sizeInfo.count * 4 < sizeInfo.pack16 * 2) {
            return new ByteSize(sizeInfo.count * 4, 4);
        }
        if (sizeInfo.pack16 * 2 < sizeInfo.pack8) {
            return new ByteSize(sizeInfo.pack16 * 2, 2);
        }
        return new ByteSize(sizeInfo.pack8, 1);
    }

    private static EncodingSize packingSize(int[] data, IntColumnInfo info) {
        SizeInfo size = new SizeInfo();
        for (int datum : data) {
            Classifier.incSize(info, size, datum);
        }
        return new EncodingSize(Classifier.byteSize(size), "pack");
    }

    private static EncodingSize deltaSize(int[] data) {
        SizeInfo size = new SizeInfo();
        int prev = data[0];
        for (int i = 1; i < data.length; ++i) {
            Classifier.incSizeSigned(size, data[i] - prev);
            prev = data[i];
        }
        return new EncodingSize(Classifier.byteSize(size), "delta");
    }

    private static EncodingSize rleSize(int[] data, IntColumnInfo info) {
        SizeInfo size = new SizeInfo();
        int run = 1;
        for (int i = 1; i < data.length; ++i) {
            if (data[i - 1] != data[i]) {
                Classifier.incSize(info, size, data[i - 1]);
                Classifier.incSize(info, size, run);
                run = 1;
                continue;
            }
            ++run;
        }
        Classifier.incSize(info, size, data[data.length - 1]);
        Classifier.incSize(info, size, run);
        return new EncodingSize(Classifier.byteSize(size), "rle");
    }

    private static EncodingSize deltaRleSize(int[] data) {
        SizeInfo size = new SizeInfo();
        int run = 1;
        int prev = 0;
        int prevValue = 0;
        for (int i = 1; i < data.length; ++i) {
            int v = data[i] - prev;
            if (prevValue != v) {
                Classifier.incSizeSigned(size, prevValue);
                Classifier.incSizeSigned(size, run);
                run = 1;
            } else {
                ++run;
            }
            prevValue = v;
            prev = data[i];
        }
        Classifier.incSizeSigned(size, prevValue);
        Classifier.incSizeSigned(size, run);
        return new EncodingSize(Classifier.byteSize(size), "delta-rle");
    }

    private static IntColumnInfo getInfo(IntArray data) {
        boolean signed = data.isSigned();
        return signed ? IntColumnInfo.SIGNED_INFO : IntColumnInfo.UNSIGNED_INFO;
    }

    private static EncodingSize getSize(IntArray data) {
        return Classifier.getSize(data.getData(), Classifier.getInfo(data));
    }

    private static EncodingSize getSize(int[] array, IntColumnInfo info) {
        return Stream.of(Classifier.packingSize(array, info), Classifier.rleSize(array, info), Classifier.deltaSize(array), Classifier.deltaRleSize(array)).min(Comparator.comparingInt(encoding -> encoding.length)).orElseThrow(NoSuchElementException::new);
    }

    public static EncodingStrategyHint classify(Float64Array data) {
        EncodingStrategyHint hint = Classifier.classifyPrecision(data);
        if ("byte".equals(hint.getEncoding())) {
            return hint;
        }
        int multiplier = Classifier.getMultiplier(hint.getPrecision());
        double[] doubles = data.getData();
        int[] intArray = new int[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            intArray[i] = (int)Math.round(doubles[i] * (double)multiplier);
        }
        EncodingSize size = Classifier.getSize(intArray, IntColumnInfo.SIGNED_INFO);
        hint.setEncoding(size.kind);
        return hint;
    }

    public static EncodingStrategyHint classifyPrecision(Float64Array data) {
        EncodingStrategyHint hint = new EncodingStrategyHint();
        int maxDigits = 4;
        int[] arrayDigitCount = Classifier.getArrayDigitCount(data.getData(), maxDigits);
        int mantissaDigits = arrayDigitCount[0];
        int integerDigits = arrayDigitCount[1];
        if (mantissaDigits < 0 || mantissaDigits + integerDigits > 10) {
            hint.setEncoding("byte");
            return hint;
        }
        if (mantissaDigits == 0) {
            throw new UnsupportedOperationException("cannot handle yet, impl me");
        }
        hint.setPrecision(mantissaDigits);
        return hint;
    }

    private static int getMultiplier(int mantissaDigits) {
        int m = 1;
        for (int i = 0; i < mantissaDigits; ++i) {
            m *= 10;
        }
        return m;
    }

    private static int[] getArrayDigitCount(double[] xs, int maxDigits) {
        int mantissaDigits = 1;
        int integerDigits = 0;
        for (double x : xs) {
            int d;
            double abs;
            if (mantissaDigits >= 0) {
                int t = Classifier.getMantissaMultiplier(x, maxDigits);
                if (t < 0) {
                    mantissaDigits = -1;
                } else if (t > mantissaDigits) {
                    mantissaDigits = t;
                }
            }
            if (!((abs = Math.abs(x)) > 1.0E-6) || (d = (int)(Math.floor(Math.log10(Math.abs(abs))) + 1.0)) <= integerDigits) continue;
            integerDigits = d;
        }
        return new int[]{mantissaDigits, integerDigits};
    }

    private static int getMantissaMultiplier(double v, int maxDigits) {
        int m = 1;
        for (int i = 0; i < maxDigits; ++i) {
            double mv = (double)m * v;
            if (Math.abs((double)Math.round(mv) - mv) <= 1.0E-6) {
                return i;
            }
            m *= 10;
        }
        return -1;
    }

    static class EncodingSize
    extends ByteSize {
        final String kind;

        EncodingSize(ByteSize byteSize, String kind) {
            super(byteSize.length, byteSize.elem);
            this.kind = kind;
        }

        public String toString() {
            return "{kind='" + this.kind + "', length=" + this.length + '}';
        }
    }

    static class SizeInfo {
        int pack8;
        int pack16;
        int count;

        SizeInfo() {
        }
    }

    static class IntColumnInfo {
        static final IntColumnInfo SIGNED_INFO = new IntColumnInfo(true, 127, Short.MAX_VALUE);
        static final IntColumnInfo UNSIGNED_INFO = new IntColumnInfo(false, 255, 65535);
        final boolean signed;
        final int limit8;
        final int limit16;

        IntColumnInfo(boolean signed, int limit8, int limit16) {
            this.signed = signed;
            this.limit8 = limit8;
            this.limit16 = limit16;
        }
    }

    static class ByteSize {
        final int length;
        final int elem;

        ByteSize(int length, int elem) {
            this.length = length;
            this.elem = elem;
        }
    }
}

