/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import org.rcsb.cif.binary.data.Int16Array;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.Int8Array;
import org.rcsb.cif.binary.data.NumberArray;
import org.rcsb.cif.binary.data.Uint16Array;
import org.rcsb.cif.binary.data.Uint32Array;
import org.rcsb.cif.binary.data.Uint8Array;
import org.rcsb.cif.binary.encoding.IntegerPackingEncoding;
import org.rcsb.cif.binary.encoding.RunLengthEncoding;

public interface IntArray
extends NumberArray<int[]> {
    @Override
    public int[] getData();

    @Override
    default public int length() {
        return this.getData().length;
    }

    public boolean isSigned();

    default public Int32Array encode(RunLengthEncoding encoding) {
        return encoding.encode(this);
    }

    default public Int32Array decode(IntegerPackingEncoding encoding) {
        return encoding.decode(this);
    }

    public static IntArray create(int type, int size) {
        int[] data = new int[size];
        switch (type) {
            case 1: {
                return new Int8Array(data);
            }
            case 2: {
                return new Int16Array(data);
            }
            case 3: {
                return new Int32Array(data);
            }
            case 4: {
                return new Uint8Array(data);
            }
            case 5: {
                return new Uint16Array(data);
            }
            case 6: {
                return new Uint32Array(data);
            }
        }
        throw new IllegalArgumentException("Unknown IntArray type " + type);
    }
}

