/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;

public interface Block {
    public String getBlockHeader();

    public Category getCategory(String var1);

    default public Column<?> getColumn(String name) {
        Map<String, Category> categories = this.getCategories();
        if (categories.containsKey(name)) {
            return categories.get(name).getColumn("");
        }
        return Column.EmptyColumn.UNNAMED_COLUMN;
    }

    public Map<String, Category> getCategories();

    default public Stream<Category> categories() {
        return this.getCategories().values().stream();
    }

    public List<Block> getSaveFrames();

    default public Stream<Block> saveFrames() {
        return this.getSaveFrames().stream();
    }

    default public <C extends Category> C getCategory(String name, Function<Category, C> wrapper) {
        Category category = this.getCategory(name);
        return (C)((Category)wrapper.apply(category != null ? category : new Category.EmptyCategory(name)));
    }
}

