/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.binary;

import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.ValueKind;

public abstract class BinaryColumn<T>
implements Column<T> {
    private final String name;
    private final int rowCount;
    private final boolean hasMask;
    private final int[] mask;

    public BinaryColumn(String name, int rowCount, int[] mask) {
        this.name = name;
        this.rowCount = rowCount;
        this.hasMask = mask != null && mask.length > 0;
        this.mask = mask;
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public ValueKind getValueKind(int row) {
        if (!this.hasMask) {
            return ValueKind.PRESENT;
        }
        return ValueKind.values()[this.mask[row]];
    }

    public int[] getMask() {
        return this.mask;
    }
}

