/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.rcsb.cif.model.BlockBuilder;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CategoryBuilder;
import org.rcsb.cif.model.CifFileBuilder;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.ColumnBuilder;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.FloatColumnBuilder;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.IntColumnBuilder;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.model.StrColumnBuilder;
import org.rcsb.cif.model.builder.FloatColumnBuilderImpl;
import org.rcsb.cif.model.builder.IntColumnBuilderImpl;
import org.rcsb.cif.model.builder.StrColumnBuilderImpl;
import org.rcsb.cif.model.text.TextCategory;

public class CategoryBuilderImpl<P extends BlockBuilder<PP>, PP extends CifFileBuilder>
implements CategoryBuilder<P, PP> {
    private final String categoryName;
    private final Map<String, Column<?>> columns;
    protected final P parent;
    private final List<ColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP>> pendingDigests;
    private final List<ColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP>> finishedDigests;

    public CategoryBuilderImpl(String categoryName, P parent) {
        this.categoryName = categoryName;
        this.columns = new LinkedHashMap();
        this.parent = parent;
        this.pendingDigests = new ArrayList<ColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP>>();
        this.finishedDigests = new ArrayList<ColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP>>();
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public Map<String, Column<?>> getColumns() {
        return this.columns;
    }

    @Override
    public P leaveCategory() {
        if (this.parent == null) {
            throw new IllegalStateException("cannot leave category with undefined parent block");
        }
        this.pendingDigests.stream().filter(child -> !this.finishedDigests.contains(child)).forEach(child -> {
            if (child instanceof IntColumnBuilder) {
                this.digest((IntColumnBuilder)child);
            } else if (child instanceof FloatColumnBuilder) {
                this.digest((FloatColumnBuilder)child);
            } else {
                this.digest((StrColumnBuilder)child);
            }
        });
        this.parent.digest(this);
        return this.parent;
    }

    @Override
    public Category build() {
        return new TextCategory(this.categoryName, this.columns);
    }

    @Override
    public CategoryBuilder<P, PP> addColumn(Column<?> column) {
        this.columns.put(column.getColumnName(), column);
        return this;
    }

    @Override
    public void digest(IntColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP> columnBuilder) {
        this.columns.put(columnBuilder.getColumnName(), CategoryBuilder.createColumnText(columnBuilder.getColumnName(), columnBuilder.getValues(), columnBuilder.getMask(), IntColumn.class));
        this.finishedDigests.add(columnBuilder);
    }

    @Override
    public void digest(FloatColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP> columnBuilder) {
        this.columns.put(columnBuilder.getColumnName(), CategoryBuilder.createColumnText(columnBuilder.getColumnName(), columnBuilder.getValues(), columnBuilder.getMask(), FloatColumn.class));
        this.finishedDigests.add(columnBuilder);
    }

    @Override
    public void digest(StrColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP> columnBuilder) {
        this.columns.put(columnBuilder.getColumnName(), CategoryBuilder.createColumnText(columnBuilder.getColumnName(), columnBuilder.getValues(), columnBuilder.getMask(), StrColumn.class));
        this.finishedDigests.add(columnBuilder);
    }

    @Override
    public IntColumnBuilder<CategoryBuilder<P, PP>, P, PP> enterIntColumn(String columnName) {
        return new IntColumnBuilderImpl(this.getCategoryName(), columnName, this);
    }

    @Override
    public FloatColumnBuilder<CategoryBuilder<P, PP>, P, PP> enterFloatColumn(String columnName) {
        return new FloatColumnBuilderImpl(this.getCategoryName(), columnName, this);
    }

    @Override
    public StrColumnBuilder<CategoryBuilder<P, PP>, P, PP> enterStrColumn(String columnName) {
        return new StrColumnBuilderImpl(this.getCategoryName(), columnName, this);
    }

    @Override
    public void registerChild(ColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP> builder) {
        this.pendingDigests.add(builder);
    }
}

