/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.schema;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.schema.DelegatingColumn;
import org.rcsb.cif.schema.core.CifCoreBlock;

public class DelegatingCategory
implements Category {
    protected final Category delegate;

    public DelegatingCategory(Category delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getCategoryName() {
        return this.delegate.getCategoryName();
    }

    @Override
    public int getRowCount() {
        return this.delegate.getRowCount();
    }

    @Override
    public Column<?> getColumn(String name) {
        return this.getColumns().computeIfAbsent(name, Column.EmptyColumn::new);
    }

    @Override
    public Map<String, Column<?>> getColumns() {
        LinkedHashMap columns = new LinkedHashMap();
        for (Map.Entry<String, Column<?>> entry : this.delegate.getColumns().entrySet()) {
            Column<?> column = entry.getValue();
            if (column instanceof DelegatingColumn) {
                columns.put(entry.getKey(), column);
                continue;
            }
            columns.put(entry.getKey(), this.createDelegate(entry.getKey(), entry.getValue()));
        }
        return columns;
    }

    @Override
    public List<String> getColumnNames() {
        return this.delegate.getColumnNames();
    }

    protected Column<?> createDelegate(String columnName, Column<?> column) {
        return new DelegatingColumn(column);
    }

    public static class DelegatingCifCoreCategory
    implements Category {
        private final String categoryName;
        protected final CifCoreBlock parentBlock;
        private final List<String> CIF_CORE_COLUMN_NAMES = Stream.of("").collect(Collectors.toList());

        public DelegatingCifCoreCategory(String categoryName, CifCoreBlock parentBlock) {
            this.categoryName = categoryName;
            this.parentBlock = parentBlock;
        }

        @Override
        public String getCategoryName() {
            return this.categoryName;
        }

        @Override
        public int getRowCount() {
            return this.parentBlock.categories().filter(category -> category.getCategoryName().startsWith(this.categoryName)).findFirst().map(Category::getRowCount).orElse(0);
        }

        @Override
        public Column<?> getColumn(String name) {
            return this.parentBlock.getColumn(this.categoryName + "_" + name);
        }

        @Override
        public Map<String, Column<?>> getColumns() {
            return this.parentBlock.categories().filter(category -> category.getCategoryName().startsWith(this.categoryName)).collect(Collectors.toMap(this::extractName, category -> category.getColumn("")));
        }

        @Override
        public List<String> getColumnNames() {
            return this.CIF_CORE_COLUMN_NAMES;
        }

        private String extractName(Category category) {
            return category.getCategoryName().replaceFirst(this.categoryName + "_", "");
        }
    }
}

