/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.schema.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.rcsb.cif.CifIO;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.schema.DelegatingColumn;
import org.rcsb.cif.schema.DelegatingFloatColumn;
import org.rcsb.cif.schema.DelegatingIntColumn;
import org.rcsb.cif.schema.DelegatingStrColumn;
import org.rcsb.cif.schema.generator.Col;
import org.rcsb.cif.schema.generator.CoordCol;
import org.rcsb.cif.schema.generator.EnumCol;
import org.rcsb.cif.schema.generator.FloatCol;
import org.rcsb.cif.schema.generator.IntCol;
import org.rcsb.cif.schema.generator.ListCol;
import org.rcsb.cif.schema.generator.MatrixCol;
import org.rcsb.cif.schema.generator.StrCol;
import org.rcsb.cif.schema.generator.Table;
import org.rcsb.cif.schema.generator.VectorCol;

public class SchemaGenerator {
    private static final Path OUTPUT_PATH = Paths.get("/Users/sebastian/model/", new String[0]);
    private static final String BASE_PACKAGE = "org.rcsb.cif.schema.";
    private static final String RE_MATRIX_FIELD = "\\[[1-3]]\\[[1-3]]";
    private static final String RE_VECTOR_FIELD = "\\[[1-3]]";
    private static final List<String> FORCE_INT_FIELDS = Stream.of("_atom_site.id", "_atom_site.auth_seq_id", "_pdbx_struct_mod_residue.auth_seq_id", "_struct_conf.beg_auth_seq_id", "_struct_conf.end_auth_seq_id", "_struct_conn.ptnr1_auth_seq_id", "_struct_conn.ptnr2_auth_seq_id", "_struct_sheet_range.beg_auth_seq_id", "_struct_sheet_range.end_auth_seq_id").collect(Collectors.toList());
    private static final String BLOCK = SchemaGenerator.loadTemplate("Block.tpl");
    private static final String BLOCK_FLAT = SchemaGenerator.loadTemplate("BlockFlat.tpl");
    private static final String CASE = SchemaGenerator.loadTemplate("Case.tpl");
    private static final String BLOCK_GETTER = SchemaGenerator.loadTemplate("BlockGetter.tpl");
    private static final String BLOCK_GETTER_FLAT = SchemaGenerator.loadTemplate("BlockGetterFlat.tpl");
    private static final String CATEGORY = SchemaGenerator.loadTemplate("Category.tpl");
    private static final String CATEGORY_FLAT = SchemaGenerator.loadTemplate("CategoryFlat.tpl");
    private static final String CATEGORY_GETTER = SchemaGenerator.loadTemplate("CategoryGetter.tpl");
    private static final String CATEGORY_GETTER_FLAT = SchemaGenerator.loadTemplate("CategoryGetterFlat.tpl");
    private static final String BLOCK_BUILDER = SchemaGenerator.loadTemplate("BlockBuilder.tpl");
    private static final String BLOCK_BUILDER_FLAT = SchemaGenerator.loadTemplate("BlockBuilderFlat.tpl");
    private static final String CATEGORY_BUILDER = SchemaGenerator.loadTemplate("CategoryBuilder.tpl");
    private static final String CATEGORY_BUILDER_FLAT = SchemaGenerator.loadTemplate("CategoryBuilderFlat.tpl");
    private static final String CATEGORY_BUILDER_ENTER = SchemaGenerator.loadTemplate("CategoryBuilderEnter.tpl");
    private static final String COLUMN_BUILDER = SchemaGenerator.loadTemplate("ColumnBuilder.tpl");
    private static final String COLUMN_BUILDER_ENTER = SchemaGenerator.loadTemplate("ColumnBuilderEnter.tpl");
    private final String schemaName;
    private final String packageName;
    private final boolean flat;
    private final Map<String, Table> schema;
    private final Map<String, Block> categories;
    private final Map<String, String> links;
    private final Map<String, Map<String, Category>> imports;
    private final Map<String, List<String>> rawAliases;
    private final List<List<String>> aliases;
    private static final Pattern savePattern = Pattern.compile("('save'|'save'):([^ \t\n]+)");
    private static final Pattern filePattern = Pattern.compile("('file'|'file'):([^ \t\n]+)");

    private static String loadTemplate(String name) {
        return new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("templates/" + name))).lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public static void main(String[] args) throws IOException {
        new SchemaGenerator("MmCif", "mm", false, "http://mmcif.wwpdb.org/dictionaries/ascii/mmcif_pdbx_v50.dic", "https://raw.githubusercontent.com/ihmwg/IHM-dictionary/master/ihm-extension.dic", "https://raw.githubusercontent.com/pdbxmmcifwg/carbohydrate-extension/master/dict/entity_branch-extension.dic", "https://raw.githubusercontent.com/pdbxmmcifwg/carbohydrate-extension/master/dict/chem_comp-extension.dic");
    }

    static String toClassName(String rawName) {
        String name = Pattern.compile("_").splitAsStream(rawName).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining("")).replaceAll("[/\\\\\\- \t`~!@#$%^&*()=+{}|;:'\",<.>?]", "_").replaceAll("_+", "_").replace("[", "").replace("]", "");
        if (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.equals("Class")) {
            return "Clazz";
        }
        if (Character.isDigit(name.charAt(0))) {
            return "_" + name;
        }
        return name;
    }

    private void writeClasses() throws IOException {
        this.writeBlockImpl(this.schema, OUTPUT_PATH);
    }

    private void writeBlockImpl(Map<String, Table> content, Path path) throws IOException {
        TreeSet<String> alreadyWritten = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        String className = this.schemaName + "Block";
        String block = (this.flat ? BLOCK_FLAT : BLOCK).replace("{packageName}", this.packageName).replace("{schemaName}", this.schemaName);
        String blockBuilder = (this.flat ? BLOCK_BUILDER_FLAT : BLOCK_BUILDER).replace("{packageName}", this.packageName).replace("{schemaName}", this.schemaName);
        String categoryBuilder = (this.flat ? CATEGORY_BUILDER_FLAT : CATEGORY_BUILDER).replace("{packageName}", this.packageName).replace("{schemaName}", this.schemaName);
        StringJoiner getters = new StringJoiner("\n");
        StringJoiner cases = new StringJoiner("\n");
        StringJoiner enters = new StringJoiner("\n");
        StringJoiner categoryEnters = new StringJoiner("\n");
        for (Map.Entry<String, Table> entry : content.entrySet()) {
            String categoryName = entry.getKey();
            Table category = entry.getValue();
            if (!alreadyWritten.add(categoryName)) {
                System.err.println("skipping " + categoryName);
                continue;
            }
            String categoryClassName = SchemaGenerator.toClassName(categoryName);
            String description = this.prepareDescription(category.getDescription(), "     * ");
            if (this.flat) {
                getters.add(BLOCK_GETTER_FLAT.replace("{categoryDescription}", description).replace("{categoryClassName}", categoryClassName).replace("{categoryName}", categoryName));
            } else {
                getters.add(BLOCK_GETTER.replace("{categoryDescription}", description).replace("{categoryClassName}", categoryClassName).replace("{categoryName}", categoryName));
            }
            this.writeCategory(category.getDescription(), categoryClassName, entry.getValue(), path, categoryName, categoryClassName, categoryEnters);
            cases.add(CASE.replace("{name}", categoryName).replace("{className}", categoryClassName));
            String enter = CATEGORY_BUILDER_ENTER.replace("{schemaName}", this.schemaName).replace("{categoryClassName}", categoryClassName);
            enters.add(enter);
        }
        block = block.replace("{cases}", cases.toString()).replace("{getters}", getters.toString());
        blockBuilder = blockBuilder.replace("{enters}", enters.toString());
        categoryBuilder = categoryBuilder.replace("{enters}", categoryEnters.toString());
        Files.write(path.resolve(this.schemaName + "BlockBuilder.java"), blockBuilder.toString().getBytes(), new OpenOption[0]);
        Files.write(path.resolve(this.schemaName + "CategoryBuilder.java"), categoryBuilder.toString().getBytes(), new OpenOption[0]);
        Files.write(path.resolve(className + ".java"), block.toString().getBytes(), new OpenOption[0]);
    }

    private String prepareDescription(String description, String prefix) {
        return Pattern.compile("\n").splitAsStream(description.trim()).map(s -> prefix + s).collect(Collectors.joining("\n")).replace("TODO", "");
    }

    private void writeCategory(String categoryDescription, String className, Table content, Path path, String categoryName, String categoryClassName, StringJoiner categoryEnters) throws IOException {
        Path generatedPath;
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        if (!Files.exists(generatedPath = path.resolve("generated"), new LinkOption[0])) {
            Files.createDirectory(generatedPath, new FileAttribute[0]);
        }
        categoryDescription = this.prepareDescription(categoryDescription, " * ");
        String category = (this.flat ? CATEGORY_FLAT : CATEGORY).replace("{packageName}", this.packageName).replace("{schemaName}", this.schemaName).replace("{categoryDescription}", categoryDescription).replace("{categoryClassName}", categoryClassName).replace("{categoryName}", categoryName);
        StringJoiner getters = new StringJoiner("\n");
        StringJoiner cases = new StringJoiner("\n");
        StringJoiner enters = new StringJoiner("\n");
        for (Map.Entry<String, Object> entry : content.getColumns().entrySet()) {
            String columnName = entry.getKey();
            String flatName = categoryName + "_" + columnName;
            Col column = (Col)entry.getValue();
            if (this.aliases.stream().anyMatch(list -> list.contains(categoryName + "." + columnName))) continue;
            String columnClassName = SchemaGenerator.toClassName(columnName);
            Class<? extends Column> baseClass = this.getBaseClass(column.getType());
            Class<? extends DelegatingColumn> delegatingBaseClass = this.getDelegatingBaseClass(column.getType());
            String baseClassName = baseClass.getSimpleName();
            String delegatingBaseClassName = delegatingBaseClass.getSimpleName();
            String description = this.prepareDescription(column.getDescription(), "     * ");
            getters.add((this.flat ? CATEGORY_GETTER_FLAT : CATEGORY_GETTER).replace("{columnDescription}", description).replace("{baseClassName}", baseClassName).replace("{columnClassName}", columnClassName).replace("{columnName}", columnName).replace("{modifier}", "").replace("{aliases}", "\"" + flatName + "\""));
            cases.add(CASE.replace("{name}", columnName).replace("{className}", columnClassName));
            enters.add(COLUMN_BUILDER_ENTER.replace("{schemaName}", this.schemaName).replace("{baseClassName}", baseClassName).replace("{categoryClassName}", categoryClassName).replace("{columnClassName}", columnClassName).replace("{columnName}", columnName));
        }
        HashSet processed = new HashSet();
        this.aliases.stream().filter(set -> set.stream().anyMatch(n -> n.split("\\.")[0].equals(categoryName))).forEach(set -> set.stream().filter(n -> n.startsWith(categoryName)).forEach(cn -> {
            String as = set.stream().map(n -> n.replace(".", "_")).distinct().map(n -> "\"" + n + "\"").collect(Collectors.joining(", "));
            boolean multiple = as.split(",").length > 1;
            Col column = (Col)set.stream().map(n -> n.split("\\.")).filter(s -> this.schema.containsKey(s[0]) && this.schema.get(s[0]).getColumns().containsKey(s[1])).findFirst().map(s -> this.schema.get(s[0]).getColumns().get(s[1])).orElseThrow(() -> new NoSuchElementException());
            String columnClassName = SchemaGenerator.toClassName(cn.split("\\.")[1]);
            if (processed.contains(columnClassName)) {
                return;
            }
            processed.add(columnClassName);
            Class<? extends Column> baseClass = this.getBaseClass(column.getType());
            Class<? extends DelegatingColumn> delegatingBaseClass = this.getDelegatingBaseClass(column.getType());
            String baseClassName = baseClass.getSimpleName();
            String delegatingBaseClassName = delegatingBaseClass.getSimpleName();
            String description = this.prepareDescription(column.getDescription(), "     * ");
            getters.add(CATEGORY_GETTER_FLAT.replace("{columnDescription}", description).replace("{baseClassName}", baseClassName).replace("{columnClassName}", columnClassName).replace("{modifier}", multiple ? "Aliased" : "").replace("{aliases}", as));
            enters.add(COLUMN_BUILDER_ENTER.replace("{schemaName}", this.schemaName).replace("{baseClassName}", baseClassName).replace("{categoryClassName}", categoryClassName).replace("{columnClassName}", columnClassName).replace("{columnName}", cn.split("\\.")[1]));
        }));
        category = category.replace("{cases}", cases.toString()).replace("{getters}", getters.toString());
        categoryEnters.add(COLUMN_BUILDER.replace("{schemaName}", this.schemaName).replace("{categoryClassName}", categoryClassName).replace("{categoryName}", categoryName).replace("{columnEnters}", enters.toString()));
        Files.write(path.resolve("generated").resolve(className + ".java"), category.toString().getBytes(), new OpenOption[0]);
    }

    private Class<? extends Column> getBaseClass(String type) {
        switch (type) {
            case "coord": {
                return FloatColumn.class;
            }
            case "enum": {
                return StrColumn.class;
            }
            case "float": {
                return FloatColumn.class;
            }
            case "int": {
                return IntColumn.class;
            }
            case "list": {
                return StrColumn.class;
            }
            case "matrix": {
                return FloatColumn.class;
            }
            case "str": {
                return StrColumn.class;
            }
            case "vector": {
                return FloatColumn.class;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private Class<? extends DelegatingColumn> getDelegatingBaseClass(String type) {
        switch (type) {
            case "coord": {
                return DelegatingFloatColumn.class;
            }
            case "enum": {
                return DelegatingStrColumn.class;
            }
            case "float": {
                return DelegatingFloatColumn.class;
            }
            case "int": {
                return DelegatingIntColumn.class;
            }
            case "list": {
                return DelegatingStrColumn.class;
            }
            case "matrix": {
                return DelegatingFloatColumn.class;
            }
            case "str": {
                return DelegatingStrColumn.class;
            }
            case "vector": {
                return DelegatingFloatColumn.class;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private SchemaGenerator(String schemaName, String packageName, boolean flat, String ... resource) throws IOException {
        this.schemaName = schemaName;
        this.packageName = packageName;
        this.flat = flat;
        this.schema = new LinkedHashMap<String, Table>();
        this.categories = new LinkedHashMap<String, Block>();
        this.links = new LinkedHashMap<String, String>();
        this.imports = new LinkedHashMap<String, Map<String, Category>>();
        this.rawAliases = new LinkedHashMap<String, List<String>>();
        this.aliases = new ArrayList<List<String>>();
        for (String res : resource) {
            System.out.println(res);
            CifFile cifFile = CifIO.readFromURL(new URL(res));
            if (schemaName.equals("MmCif")) {
                this.getCategoryMetadataMmcif(cifFile);
            } else if (schemaName.equals("CifCore")) {
                this.getCategoryMetadataCifCore(cifFile);
            }
            this.buildListOfLinksBetweenCategories(cifFile);
        }
        this.getFieldData();
        if (flat) {
            this.prepareAliases();
        }
        this.writeClasses();
    }

    private void getFieldData() {
        this.categories.forEach((fullName, saveFrame) -> {
            String header;
            String categoryName = header.substring((header = saveFrame.getBlockHeader()).startsWith("_") ? 1 : 0, header.contains(".") ? header.indexOf(".") : header.length());
            String itemName = header.substring(header.indexOf(".") + 1);
            LinkedHashMap<String, Object> fields = new LinkedHashMap();
            if (saveFrame.getCategories().containsKey("import")) {
                this.parseImportGet(saveFrame.getCategory("import").getColumn("get").getStringData(0)).filter(Import::isValid).filter(i -> this.imports.containsKey(i.save) && this.imports.get(i.save).size() > 0).map(i -> this.imports.get(i.save)).forEach(i -> saveFrame.getCategories().putAll((Map<String, Category>)i));
            }
            if (this.schema.containsKey(categoryName)) {
                fields = this.schema.get(categoryName).getColumns();
                this.schema.get(categoryName).getCategoryKeyNames().add(itemName);
            } else if (this.schema.containsKey(categoryName.toLowerCase())) {
                fields = this.schema.get(categoryName.toLowerCase()).getColumns();
                this.schema.put(categoryName, this.schema.get(categoryName.toLowerCase()));
            } else {
                System.err.println("category " + categoryName + " has no metadata");
                fields = new LinkedHashMap();
                this.schema.put(categoryName, new Table("", new HashSet<String>(), fields));
            }
            List<String> itemAliases = this.getAliases((Block)saveFrame);
            if (!itemAliases.isEmpty()) {
                this.rawAliases.put(categoryName + "." + itemName, itemAliases);
            }
            String description = this.getDescription((Block)saveFrame);
            String subCategory = this.getSubCategory((Block)saveFrame);
            if ("cartesian_coordinate".equals(subCategory) || "fractional_coordinate".equals(subCategory)) {
                fields.put(itemName, new CoordCol(description));
            } else if (FORCE_INT_FIELDS.contains(header)) {
                fields.put(itemName, new IntCol(description));
            } else if ("matrix".equals(subCategory)) {
                fields.put(itemName, new MatrixCol(description));
            } else if ("vector".equals(subCategory)) {
                fields.put(itemName, new VectorCol(description));
            } else if (itemName.matches(RE_MATRIX_FIELD)) {
                fields.put(itemName, new MatrixCol(description));
            } else if (itemName.matches(RE_VECTOR_FIELD)) {
                fields.put(itemName, new VectorCol(description));
            } else {
                List<String> code = this.getCode((Block)saveFrame);
                if (code.size() > 0) {
                    Col fieldType = this.getFieldType(code.get(0), description, code.subList(1, code.size()));
                    fields.put(itemName, fieldType);
                }
            }
        });
    }

    private List<String> getAliases(Block saveFrame) {
        Column column;
        Column field = this.getField("item_aliases", "alias_name", saveFrame);
        if (field == null || !field.isDefined()) {
            field = this.getField("alias", "definition_id", saveFrame);
        }
        if ((column = field) == null) {
            return Collections.emptyList();
        }
        return IntStream.range(0, field.getRowCount()).mapToObj(i -> column.getStringData(i)).map(s -> s.substring(1)).collect(Collectors.toList());
    }

    private Col getFieldType(String type, String description, List<String> values) {
        switch (type) {
            case "code": 
            case "ucode": 
            case "line": 
            case "uline": 
            case "text": 
            case "char": 
            case "uchar3": 
            case "uchar1": 
            case "boolean": {
                return values.size() > 0 ? new EnumCol(values, "str", description) : new StrCol(description);
            }
            case "aliasname": 
            case "name": 
            case "idname": 
            case "any": 
            case "atcode": 
            case "fax": 
            case "phone": 
            case "email": 
            case "code30": 
            case "seq-one-letter-code": 
            case "author": 
            case "orcid_id": 
            case "sequence_dep": 
            case "pdb_id": 
            case "emd_id": 
            case "yyyy-mm-dd": 
            case "yyyy-mm-dd:hh:mm": 
            case "yyyy-mm-dd:hh:mm-flex": 
            case "int-range": 
            case "float-range": 
            case "binary": 
            case "operation_expression": 
            case "point_symmetry": 
            case "4x3_matrix": 
            case "3x4_matrices": 
            case "point_group": 
            case "point_group_helical": 
            case "symmetry_operation": 
            case "date_dep": 
            case "url": 
            case "symop": 
            case "exp_data_doi": 
            case "asym_id": {
                return new StrCol(description);
            }
            case "int": 
            case "non_negative_int": 
            case "positive_int": {
                return values.size() > 0 ? new EnumCol(values, "int", description) : new IntCol(description);
            }
            case "float": {
                return new FloatCol(description);
            }
            case "ec-type": 
            case "ucode-alphanum-csv": 
            case "id_list": {
                return new ListCol("str", ",", description);
            }
            case "id_list_spc": {
                return new ListCol("str", " ", description);
            }
            case "Text": 
            case "Code": 
            case "Complex": 
            case "Symop": 
            case "List": 
            case "List(Real,Real)": 
            case "List(Real,Real,Real,Real)": 
            case "Date": 
            case "Datetime": 
            case "Tag": 
            case "Implied": {
                return new StrCol(description);
            }
            case "Real": {
                return new FloatCol(description);
            }
            case "Integer": {
                return new IntCol(description);
            }
        }
        return new StrCol(description);
    }

    private List<String> getCode(Block saveFrame) {
        Column code = this.getField("item_type", "code", saveFrame);
        if (code == null || !code.isDefined()) {
            code = this.getField("type", "contents", saveFrame);
        }
        if (code != null && code.getRowCount() > 0) {
            return Stream.concat(Stream.of(code.getStringData(0)), this.getEnums(saveFrame)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Stream<String> getEnums(Block saveFrame) {
        Column value = this.getField("item_enumeration", "value", saveFrame);
        if (value != null) {
            return IntStream.range(0, value.getRowCount()).mapToObj(value::getStringData);
        }
        return Stream.empty();
    }

    private String getSubCategory(Block saveFrame) {
        try {
            Column value = this.getField("item_sub_category", "id", saveFrame);
            return value.getStringData(0);
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private String getDescription(Block saveFrame) {
        Column value = this.getField("item_description", "description", saveFrame);
        if (value == null || !value.isDefined()) {
            value = this.getField("description", "text", saveFrame);
        }
        if (value == null) {
            return null;
        }
        String escapedDescription = this.escape(value.getStringData(0));
        return Pattern.compile("\n").splitAsStream(escapedDescription).map(String::trim).collect(Collectors.joining("\n")).replaceAll("(\\[[1-3]])+ element", "elements").replaceAll("(\\[[1-3]])+", "");
    }

    private Column getField(String category, String field, Block saveFrame) {
        Category cat = saveFrame.getCategory(category);
        if (cat.isDefined()) {
            return cat.getColumn(field);
        }
        if (this.links.containsKey(saveFrame.getBlockHeader())) {
            String linkName = this.links.get(saveFrame.getBlockHeader());
            Block block = this.categories.get(linkName);
            if (block != null) {
                return this.getField(category, field, block);
            }
            System.err.println("link " + linkName + "not found");
            return null;
        }
        return null;
    }

    private void buildListOfLinksBetweenCategories(CifFile cifFile) {
        cifFile.getBlocks().get(0).getSaveFrames().stream().filter(saveFrame -> saveFrame.getBlockHeader().startsWith("_") || saveFrame.getBlockHeader().contains(".")).forEach(saveFrame -> {
            this.categories.put(saveFrame.getBlockHeader(), (Block)saveFrame);
            Category item_linked = saveFrame.getCategory("item_linked");
            if (item_linked == null) {
                return;
            }
            Column<?> child_name = item_linked.getColumn("child_name");
            Column<?> parent_name = item_linked.getColumn("parent_name");
            for (int i = 0; i < item_linked.getRowCount(); ++i) {
                String childName = child_name.getStringData(i);
                String parentName = parent_name.getStringData(i);
                this.links.put(childName, parentName);
            }
        });
    }

    private void getCategoryMetadataMmcif(CifFile cifFile) {
        cifFile.getBlocks().get(0).getSaveFrames().stream().filter(saveFrame -> !saveFrame.getBlockHeader().startsWith("_")).forEach(saveFrame -> {
            HashSet<String> categoryKeyNames = new HashSet<String>();
            Column<?> cifColumn = saveFrame.getCategory("category_key").getColumn("name");
            for (int i = 0; i < cifColumn.getRowCount(); ++i) {
                categoryKeyNames.add(cifColumn.getStringData(i));
            }
            String rawDescription = saveFrame.getCategory("category").getColumn("description").getStringData(0);
            String escapedDescription = this.escape(rawDescription);
            String description = Pattern.compile("\n").splitAsStream(escapedDescription).map(String::trim).collect(Collectors.joining("\n"));
            this.schema.put(saveFrame.getBlockHeader(), new Table(description, categoryKeyNames, new LinkedHashMap<String, Object>()));
        });
    }

    private void getCategoryMetadataCifCore(CifFile cifFile) {
        Block block = cifFile.getBlocks().get(0);
        String cifCoreDicVersion = block.getCategory("dictionary").getColumn("version").getStringData(0);
        System.out.println("Dictionary versions: CifCore " + cifCoreDicVersion);
        if ("CORE_DIC".equals(cifFile.getBlocks().get(0).getBlockHeader())) {
            block.getSaveFrames().stream().filter(saveFrame -> !saveFrame.getBlockHeader().contains(".")).forEach(saveFrame -> {
                HashSet<String> categoryKeyNames = new HashSet<String>();
                String rawDescription = saveFrame.getCategory("description").getColumn("text").getStringData(0);
                String escapedDescription = this.escape(rawDescription);
                String description = Pattern.compile("\n").splitAsStream(escapedDescription).map(String::trim).collect(Collectors.joining("\n"));
                this.schema.put(saveFrame.getBlockHeader().toLowerCase(), new Table(description, categoryKeyNames, new LinkedHashMap<String, Object>()));
            });
        } else {
            block.getSaveFrames().forEach(b -> {
                Map map = this.imports.computeIfAbsent(b.getBlockHeader(), e -> new LinkedHashMap());
                map.putAll(b.getCategories());
            });
        }
    }

    private Stream<Import> parseImportGet(String s) {
        s = s.trim().substring(2, s.length() - 2);
        return Pattern.compile("}\\s+\\{").splitAsStream(s).map(split -> {
            Matcher save = savePattern.matcher((CharSequence)split);
            Matcher file = filePattern.matcher((CharSequence)split);
            return new Import(save, file);
        });
    }

    private String escape(String description) {
        return description.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
    }

    private void prepareAliases() {
        this.rawAliases.entrySet().stream().map(entry -> {
            String target = (String)entry.getKey();
            String flatTarget = target.replace(".", "_");
            List sources = ((List)entry.getValue()).stream().filter(s -> !s.equals(flatTarget)).filter(s -> s.contains(".")).filter(s -> !target.equals(s)).distinct().collect(Collectors.toList());
            if (sources.isEmpty()) {
                return Collections.emptyList();
            }
            sources.add(target);
            return sources;
        }).filter(list -> !list.isEmpty()).forEach(list -> {
            List alias = list;
            Optional<List> optional = this.aliases.stream().filter(set -> alias.stream().anyMatch(a -> set.contains(a))).findFirst();
            if (optional.isPresent()) {
                optional.get().addAll(alias);
            } else {
                this.aliases.add(alias);
            }
        });
        this.aliases.stream().flatMap(Collection::stream).map(name -> name.split("\\.")[0]).filter(categoryName -> !this.schema.containsKey(categoryName)).forEach(categoryName -> {
            Table table = this.schema.computeIfAbsent((String)categoryName, e -> new Table("", new HashSet<String>(), new LinkedHashMap<String, Object>()));
        });
    }

    static class Import {
        final String save;
        final String file;

        public Import(Matcher save, Matcher file) {
            this.save = save.find() ? save.group(0).substring(7).replaceAll("['\"]", "") : null;
            this.file = file.find() ? file.group(0).substring(7).replaceAll("['\"]", "") : null;
        }

        public boolean isValid() {
            return this.save != null && this.file != null;
        }

        public String toString() {
            return "Import{save='" + this.save + '\'' + ", file='" + this.file + '\'' + '}';
        }
    }
}

