/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.UnsignedIntArray;
import org.rcsb.cif.binary.encoding.ByteArrayEncoding;
import org.rcsb.cif.binary.encoding.Encoding;

public class Uint32Array
extends AbstractEncodedData<int[]>
implements UnsignedIntArray {
    private static final int NUMBER_OF_BYTES = 4;
    static final int TYPE = 6;

    public Uint32Array(int[] data) {
        this(data, (Deque<Encoding<?, ?>>)new ArrayDeque());
    }

    public Uint32Array(int[] data, Deque<Encoding<?, ?>> encoding) {
        super(data, encoding);
    }

    public Uint32Array(ByteArray array) {
        super(Uint32Array.formArray(array.getData()), array.getEncoding());
    }

    private static int[] formArray(byte[] array) {
        int[] ints = new int[array.length / 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (int)((long)byteBuffer.getInt() & 0xFFFFFFFFL);
        }
        return ints;
    }

    @Override
    public int[] getData() {
        return (int[])this.data;
    }

    @Override
    public int length() {
        return this.getData().length;
    }

    @Override
    public byte[] toByteArray() {
        return Int32Array.int32ToByteArray(this.getData());
    }

    @Override
    public int getNumberOfBytes() {
        return 4;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public ByteArray encode() {
        return ByteArrayEncoding.UINT32.encode(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + Arrays.toString(this.getData());
    }
}

