/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.Int8Array;
import org.rcsb.cif.binary.data.UnsignedIntArray;
import org.rcsb.cif.binary.encoding.ByteArrayEncoding;
import org.rcsb.cif.binary.encoding.Encoding;

public class Uint8Array
extends AbstractEncodedData<int[]>
implements UnsignedIntArray {
    private static final int NUMBER_OF_BYTES = 1;
    static final int TYPE = 4;

    public Uint8Array(int[] data) {
        this(data, (Deque<Encoding<?, ?>>)new ArrayDeque());
    }

    public Uint8Array(int[] data, Deque<Encoding<?, ?>> encoding) {
        super(data, encoding);
    }

    public Uint8Array(ByteArray array) {
        super(Uint8Array.formArray(array.getData()), array.getEncoding());
    }

    private static int[] formArray(byte[] array) {
        int[] ints = new int[array.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = byteBuffer.get() & 0xFF;
        }
        return ints;
    }

    @Override
    public int[] getData() {
        return (int[])this.data;
    }

    @Override
    public int length() {
        return this.getData().length;
    }

    @Override
    public byte[] toByteArray() {
        return Int8Array.int8ToByteArray(this.getData());
    }

    @Override
    public int getNumberOfBytes() {
        return 1;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public ByteArray encode() {
        return ByteArrayEncoding.UINT8.encode(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + Arrays.toString(this.getData());
    }
}

