/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.rcsb.cif.model.BlockBuilder;
import org.rcsb.cif.model.CategoryBuilder;
import org.rcsb.cif.model.CifFileBuilder;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.IntColumnBuilder;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.model.builder.ColumnBuilderImpl;

public class IntColumnBuilderImpl<P extends CategoryBuilder<PP, PPP>, PP extends BlockBuilder<PPP>, PPP extends CifFileBuilder>
extends ColumnBuilderImpl<P, PP, PPP>
implements IntColumnBuilder<P, PP, PPP> {
    private final List<Integer> values = new ArrayList<Integer>();

    public IntColumnBuilderImpl(String categoryName, String columnName, P parent) {
        super(categoryName, columnName, parent);
    }

    @Override
    public List<Integer> getValues() {
        return this.values;
    }

    @Override
    public IntColumnBuilder<P, PP, PPP> markNextNotPresent() {
        this.values.add(0);
        this.mask.add(ValueKind.NOT_PRESENT);
        return this;
    }

    @Override
    public IntColumnBuilder<P, PP, PPP> markNextUnknown() {
        this.values.add(0);
        this.mask.add(ValueKind.UNKNOWN);
        return this;
    }

    @Override
    public IntColumn build() {
        return CategoryBuilder.createColumnText(this.getColumnName(), this.values, this.mask, IntColumn.class);
    }

    @Override
    public IntColumnBuilder<P, PP, PPP> add(int ... values) {
        IntStream.of(values).forEach(this.values::add);
        IntStream.range(0, values.length).mapToObj(i -> ValueKind.PRESENT).forEach(this.mask::add);
        return this;
    }

    @Override
    public P leaveColumn() {
        if (this.parent == null) {
            throw new IllegalStateException("cannot leave column with undefined parent category");
        }
        this.parent.digest(this);
        return (P)this.parent;
    }
}

