/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.rcsb.cif.model.BlockBuilder;
import org.rcsb.cif.model.CategoryBuilder;
import org.rcsb.cif.model.CifFileBuilder;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.model.StrColumnBuilder;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.model.builder.ColumnBuilderImpl;

public class StrColumnBuilderImpl<P extends CategoryBuilder<PP, PPP>, PP extends BlockBuilder<PPP>, PPP extends CifFileBuilder>
extends ColumnBuilderImpl<P, PP, PPP>
implements StrColumnBuilder<P, PP, PPP> {
    private final List<String> values = new ArrayList<String>();

    public StrColumnBuilderImpl(String categoryName, String columnName, P parent) {
        super(categoryName, columnName, parent);
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public StrColumnBuilder<P, PP, PPP> markNextNotPresent() {
        this.values.add(".");
        this.mask.add(ValueKind.NOT_PRESENT);
        return this;
    }

    @Override
    public StrColumnBuilder<P, PP, PPP> markNextUnknown() {
        this.values.add("?");
        this.mask.add(ValueKind.UNKNOWN);
        return this;
    }

    @Override
    public StrColumn build() {
        return CategoryBuilder.createColumnText(this.getColumnName(), this.values, this.mask, StrColumn.class);
    }

    @Override
    public StrColumnBuilder<P, PP, PPP> add(String ... values) {
        for (String s : values) {
            if (".".equals(s)) {
                this.markNextNotPresent();
                continue;
            }
            if ("?".equals(s)) {
                this.markNextUnknown();
                continue;
            }
            this.values.add(s);
            this.mask.add(ValueKind.PRESENT);
        }
        return this;
    }

    @Override
    public P leaveColumn() {
        if (this.parent == null) {
            throw new IllegalStateException("cannot leave column with undefined parent category");
        }
        this.parent.digest(this);
        return (P)this.parent;
    }
}

