/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.text;

import java.util.stream.IntStream;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.model.ValueKind;

public class TextColumn
implements StrColumn {
    private final String name;
    private final int rowCount;
    private final String textData;
    private final int[] startToken;
    private final int[] endToken;

    public TextColumn(String name, int rowCount, String textData, int[] startToken, int[] endToken) {
        this.name = name;
        this.rowCount = rowCount;
        this.textData = textData;
        this.startToken = startToken;
        this.endToken = endToken;
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public String getStringData(int row) {
        return this.honorValueKind(this.textData.substring(this.startToken[row], this.endToken[row]));
    }

    private String honorValueKind(String value) {
        return ".".equals(value) || "?".equals(value) ? "" : value;
    }

    @Override
    public ValueKind getValueKind(int row) {
        String value = this.textData.substring(this.startToken[row], this.endToken[row]);
        if (value.isEmpty() || ".".equals(value)) {
            return ValueKind.NOT_PRESENT;
        }
        if ("?".equals(value)) {
            return ValueKind.UNKNOWN;
        }
        return ValueKind.PRESENT;
    }

    @Override
    public String[] getArray() {
        return (String[])IntStream.range(0, this.rowCount).mapToObj(this::get).toArray(String[]::new);
    }

    @Override
    public String get(int row) {
        return this.getStringData(row);
    }
}

