/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.text;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.rcsb.cif.ParsingException;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.LinkedCaseInsensitiveMap;
import org.rcsb.cif.model.text.TextCategory;
import org.rcsb.cif.model.text.TextColumn;
import org.rcsb.cif.text.CifTokenType;
import org.rcsb.cif.text.FrameContext;

class TokenizerState {
    private final String data;
    private final int length;
    private int position;
    private boolean isEscaped;
    private boolean isImportGet;
    boolean inSaveFrame;
    private int lineNumber;
    private CifTokenType tokenType;
    private int tokenStart;
    private int tokenEnd;

    TokenizerState(String data) {
        this.data = data;
        this.length = data.length();
        this.position = 0;
        this.isEscaped = false;
        this.isImportGet = false;
        this.inSaveFrame = false;
        this.lineNumber = 1;
        this.tokenType = CifTokenType.END;
        this.tokenStart = 0;
        this.tokenEnd = 0;
    }

    CifTokenType getTokenType() {
        return this.tokenType;
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    int getTokenStart() {
        return this.tokenStart;
    }

    int getTokenEnd() {
        return this.tokenEnd;
    }

    String getData() {
        return this.data;
    }

    private void eatValue() {
        while (this.position < this.length) {
            switch (this.data.charAt(this.position)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.tokenEnd = this.position;
                    return;
                }
            }
            ++this.position;
        }
        this.tokenEnd = this.position;
    }

    private void eatEscaped(int esc) {
        ++this.position;
        while (this.position < this.length) {
            char c = this.data.charAt(this.position);
            if (c == esc) {
                if (this.position + 1 >= this.length) {
                    ++this.tokenStart;
                    this.tokenEnd = this.position++;
                    this.isEscaped = true;
                    return;
                }
                char next = this.data.charAt(this.position + 1);
                if (next == '\t' || next == '\n' || next == '\r' || next == ' ') {
                    ++this.tokenStart;
                    this.tokenEnd = this.position++;
                    this.isEscaped = true;
                    return;
                }
            } else if (c == '\r' || c == '\n') {
                this.tokenEnd = this.position;
                return;
            }
            ++this.position;
        }
        this.tokenEnd = this.position;
    }

    private void eatTripleQuote() {
        this.position += 3;
        while (this.position < this.length) {
            if (this.data.charAt(this.position) == '\'' && this.isTripleQuoteAtPosition()) {
                this.tokenStart += 3;
                this.tokenEnd = this.position;
                this.isEscaped = true;
                this.position += 3;
                return;
            }
            ++this.position;
        }
        this.tokenEnd = this.position;
    }

    private void eatImportGet() {
        while (this.position < this.length) {
            if (this.data.charAt(this.position) == ']') {
                ++this.position;
                this.tokenEnd = this.position;
                this.isImportGet = false;
                return;
            }
            ++this.position;
        }
    }

    private void eatMultiline() {
        int pos;
        int prev = 59;
        for (pos = this.position + 1; pos < this.length; ++pos) {
            char c = this.data.charAt(pos);
            if (c == ';' && (prev == 10 || prev == 13)) {
                this.position = pos + 1;
                ++this.tokenStart;
                c = this.data.charAt(--pos);
                while (c == '\n' || c == '\r') {
                    c = this.data.charAt(--pos);
                }
                this.tokenEnd = pos + 1;
                this.isEscaped = true;
                return;
            }
            if (c == '\r') {
                ++this.lineNumber;
            } else if (c == '\n' && prev != 13) {
                ++this.lineNumber;
            }
            prev = c;
        }
        this.position = pos;
    }

    private void skipCommentLine() {
        while (this.position < this.length) {
            char c = this.data.charAt(this.position);
            if (c == '\r' || c == '\n') {
                return;
            }
            ++this.position;
        }
    }

    private int skipWhitespace() {
        int prev = 10;
        block5: while (this.position < this.length) {
            char c = this.data.charAt(this.position);
            switch (c) {
                case '\t': 
                case ' ': {
                    prev = c;
                    ++this.position;
                    continue block5;
                }
                case '\n': {
                    if (prev != 13) {
                        ++this.lineNumber;
                    }
                    prev = c;
                    ++this.position;
                    continue block5;
                }
                case '\r': {
                    prev = c;
                    ++this.position;
                    ++this.lineNumber;
                    continue block5;
                }
            }
            return prev;
        }
        return prev;
    }

    private boolean isData() {
        return "data".equalsIgnoreCase(this.data.substring(this.tokenStart, this.tokenStart + 4));
    }

    private boolean isSave() {
        return "save".equalsIgnoreCase(this.data.substring(this.tokenStart, this.tokenStart + 4));
    }

    private boolean isLoop() {
        return "loop".equalsIgnoreCase(this.data.substring(this.tokenStart, this.tokenStart + 4));
    }

    private boolean isImportGet() {
        try {
            return "import.get".equalsIgnoreCase(this.data.substring(this.tokenStart + 1, this.tokenStart + 11));
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private boolean isTripleQuoteAtPosition() {
        if (this.length - this.position < 2) {
            return false;
        }
        if (this.data.charAt(this.position + 1) != '\'') {
            return false;
        }
        return this.data.charAt(this.position + 2) == '\'';
    }

    private boolean isNamespace(int start, int end) {
        int i;
        int nsLen = end - start;
        int offset = this.tokenStart - start;
        int tokenLen = this.tokenEnd - this.tokenStart;
        if (tokenLen < nsLen) {
            return false;
        }
        for (i = start; i < end; ++i) {
            if (this.data.charAt(i) == this.data.charAt(i + offset)) continue;
            return false;
        }
        if (nsLen == tokenLen) {
            return true;
        }
        return this.data.charAt(i + offset) == '.';
    }

    private int getNamespaceEnd() {
        int index = this.data.substring(this.tokenStart, this.tokenEnd).indexOf(".");
        return index != -1 ? index + this.tokenStart : this.tokenEnd;
    }

    private String getNamespace(int endIndex) {
        return this.data.substring(this.tokenStart, endIndex);
    }

    private String getTokenString() {
        return this.data.substring(this.tokenStart, this.tokenEnd);
    }

    private void moveNextInternal() {
        int prev = this.skipWhitespace();
        if (this.position >= this.length) {
            this.tokenType = CifTokenType.END;
            return;
        }
        this.tokenStart = this.position;
        this.tokenEnd = this.position;
        this.isEscaped = false;
        char c = this.data.charAt(this.position);
        switch (c) {
            case '#': {
                this.skipCommentLine();
                this.tokenType = CifTokenType.COMMENT;
                break;
            }
            case '\"': 
            case '\'': {
                if (this.isTripleQuoteAtPosition()) {
                    this.eatTripleQuote();
                    this.tokenType = CifTokenType.VALUE;
                    break;
                }
                this.eatEscaped(c);
                this.tokenType = CifTokenType.VALUE;
                break;
            }
            case ';': {
                if (prev == 10 || prev == 13) {
                    this.eatMultiline();
                } else {
                    this.eatValue();
                }
                this.tokenType = CifTokenType.VALUE;
                break;
            }
            default: {
                if (this.isImportGet) {
                    this.eatImportGet();
                } else {
                    this.eatValue();
                }
                if (this.isEscaped) {
                    this.tokenType = CifTokenType.VALUE;
                    break;
                }
                if (this.data.charAt(this.tokenStart) == '_') {
                    if (this.inSaveFrame && this.isImportGet()) {
                        this.isImportGet = true;
                    }
                    this.tokenType = CifTokenType.COLUMN_NAME;
                    break;
                }
                if (this.tokenEnd - this.tokenStart >= 5 && this.data.charAt(this.tokenStart + 4) == '_') {
                    if (this.isData()) {
                        this.tokenType = CifTokenType.DATA;
                        break;
                    }
                    if (this.isSave()) {
                        this.tokenType = CifTokenType.SAVE;
                        break;
                    }
                    if (this.isLoop()) {
                        this.tokenType = CifTokenType.LOOP;
                        break;
                    }
                    this.tokenType = CifTokenType.VALUE;
                    break;
                }
                this.tokenType = CifTokenType.VALUE;
            }
        }
    }

    void moveNext() {
        this.moveNextInternal();
        while (this.tokenType == CifTokenType.COMMENT) {
            this.moveNextInternal();
        }
    }

    void handleSingle(FrameContext ctx) throws ParsingException {
        int nsStart = this.tokenStart;
        int nsEnd = this.getNamespaceEnd();
        String name = this.getNamespace(nsEnd);
        boolean isFlat = this.isFlatNamespace();
        LinkedCaseInsensitiveMap fields = new LinkedCaseInsensitiveMap();
        String categoryName = name.substring(1);
        while (this.tokenType == CifTokenType.COLUMN_NAME && this.isNamespace(nsStart, nsEnd)) {
            String columnName = isFlat ? "" : this.getTokenString().substring(name.length() + 1);
            this.moveNext();
            if (this.tokenType != CifTokenType.VALUE) {
                throw new ParsingException("Expected value.", this.lineNumber);
            }
            Column<?> cifColumn = this.createColumn(columnName, this.data, new int[]{this.tokenStart}, new int[]{this.tokenEnd});
            fields.put(columnName, cifColumn);
            this.moveNext();
        }
        ctx.getCategories().put(categoryName, this.createCategory(categoryName, fields));
    }

    void handleLoop(FrameContext ctx) {
        int loopLine = this.lineNumber;
        this.moveNext();
        String name = this.getNamespace(this.getNamespaceEnd());
        boolean isFlat = this.isFlatNamespace();
        int columnCountEstimate = 32;
        int rowCountEstimate = "_atom_site".equals(name) ? this.data.length() / 100 : 32;
        ArrayList<String> columnNames = new ArrayList<String>(columnCountEstimate);
        ArrayList start = new ArrayList(columnCountEstimate);
        ArrayList end = new ArrayList(columnCountEstimate);
        int tokenCount = 0;
        while (this.tokenType == CifTokenType.COLUMN_NAME) {
            String columnName = isFlat ? this.getTokenString() : this.getTokenString().substring(name.length() + 1);
            columnNames.add(columnName);
            this.moveNext();
            start.add(new ArrayList(rowCountEstimate));
            end.add(new ArrayList(rowCountEstimate));
        }
        while (this.tokenType == CifTokenType.VALUE) {
            int i = tokenCount % columnNames.size();
            ((List)start.get(i)).add(this.tokenStart);
            ((List)end.get(i)).add(this.tokenEnd);
            this.moveNext();
            ++tokenCount;
        }
        if (start.size() % columnNames.size() != 0) {
            throw new ParsingException("The number of values for loop starting at line " + loopLine + " is not a multiple of the number of columns.");
        }
        if (isFlat) {
            for (int i = 0; i < start.size(); ++i) {
                String flatName = ((String)columnNames.get(i)).substring(1);
                Column<?> cifColumn = this.createColumn("", this.data, this.toArray((List)start.get(i)), this.toArray((List)end.get(i)));
                LinkedHashMap columnMap = new LinkedHashMap(1);
                columnMap.put("", cifColumn);
                ctx.getCategories().put(flatName, this.createCategory(flatName, columnMap));
            }
        } else {
            String categoryName = name.substring(1);
            LinkedCaseInsensitiveMap columns = new LinkedCaseInsensitiveMap();
            for (int i = 0; i < start.size(); ++i) {
                Column<?> cifColumn = this.createColumn((String)columnNames.get(i), this.data, this.toArray((List)start.get(i)), this.toArray((List)end.get(i)));
                columns.put((String)columnNames.get(i), cifColumn);
            }
            ctx.getCategories().put(categoryName, this.createCategory(categoryName, columns));
        }
    }

    private boolean isFlatNamespace() {
        return !this.data.substring(this.tokenStart, this.tokenEnd).contains(".");
    }

    private int[] toArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    private Column<?> createColumn(String columnName, String data, int[] startToken, int[] endToken) {
        return new TextColumn(columnName, startToken.length, data, startToken, endToken);
    }

    private Category createCategory(String categoryName, Map<String, Column<?>> textColumns) {
        return new TextCategory(categoryName, textColumns);
    }
}

