/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.codec;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public class MessagePackCodec {
    private MessagePackCodec() {
    }

    public static byte[] encode(Map<String, Object> input) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            MessagePackCodec.encodeInternal(input, dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void encodeInternal(Object input, DataOutputStream stream) throws IOException {
        if (input instanceof String) {
            String value = (String)input;
            int length = value.length();
            if (length < 32) {
                stream.writeByte(length | 0xA0);
            } else if (length < 256) {
                stream.writeByte(217);
                stream.writeByte(length);
            } else if (length < 65536) {
                stream.writeByte(218);
                stream.writeShort(length);
            } else {
                stream.writeByte(219);
                stream.writeInt(length);
            }
            stream.write(value.getBytes(StandardCharsets.US_ASCII));
            return;
        }
        if (input instanceof byte[]) {
            byte[] value = (byte[])input;
            int length = value.length;
            if (length < 256) {
                stream.writeByte(196);
                stream.writeByte(length);
            } else if (length < 65536) {
                stream.writeByte(197);
                stream.writeShort(length);
            } else {
                stream.writeByte(198);
                stream.writeInt(length);
            }
            stream.write(value);
            return;
        }
        if (input instanceof Integer || input instanceof Double) {
            if (input instanceof Double && Double.isInfinite((Double)input)) {
                throw new IllegalArgumentException("Number not finite: " + input);
            }
            if (input instanceof Double) {
                double value = (Double)input;
                stream.writeByte(203);
                stream.writeDouble(value);
                return;
            }
            int value = (Integer)input;
            if (value >= 0) {
                if (value < 128) {
                    stream.writeByte(value);
                } else if (value < 256) {
                    stream.writeByte(204);
                    stream.writeByte(value);
                } else if (value < 65536) {
                    stream.writeByte(205);
                    stream.writeShort(value);
                } else {
                    stream.writeByte(206);
                    stream.writeInt(value);
                }
                return;
            }
            if (value >= -32) {
                stream.writeByte(value);
            } else if (value >= -128) {
                stream.writeByte(208);
                stream.writeByte(value);
            } else if (value >= Short.MIN_VALUE) {
                stream.writeByte(209);
                stream.writeShort(value);
            } else {
                stream.writeByte(210);
                stream.writeInt(value);
            }
            return;
        }
        if (input == null) {
            stream.writeByte(192);
            return;
        }
        if (input instanceof Boolean) {
            boolean value = (Boolean)input;
            stream.writeByte(value ? 195 : 194);
            return;
        }
        boolean isArray = input.getClass().isArray();
        int length = isArray ? ((Object[])input).length : ((Map)input).size();
        if (length < 16) {
            stream.writeByte(length | (isArray ? 144 : 128));
        } else if (length < 65536) {
            stream.writeByte(isArray ? 220 : 222);
            stream.writeShort(length);
        } else {
            stream.writeByte(isArray ? 221 : 223);
            stream.writeInt(length);
        }
        if (isArray) {
            Object[] value;
            for (Object object : value = (Object[])input) {
                MessagePackCodec.encodeInternal(object, stream);
            }
        } else {
            Map value = (Map)input;
            for (Map.Entry entry : value.entrySet()) {
                MessagePackCodec.encodeInternal(entry.getKey(), stream);
                MessagePackCodec.encodeInternal(entry.getValue(), stream);
            }
        }
    }

    public static Map<String, Object> decode(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        Map map = (Map)MessagePackCodec.decodeInternal(dataInputStream);
        dataInputStream.close();
        return map;
    }

    private static Object decodeInternal(DataInputStream inputStream) throws IOException {
        byte int8 = inputStream.readByte();
        int type = int8 & 0xFF;
        if ((type & 0x80) == 0) {
            return type;
        }
        if ((type & 0xF0) == 128) {
            return MessagePackCodec.map(inputStream, type & 0xF);
        }
        if ((type & 0xF0) == 144) {
            return MessagePackCodec.array(inputStream, type & 0xF);
        }
        if ((type & 0xE0) == 160) {
            return MessagePackCodec.str(inputStream, type & 0x1F);
        }
        if ((type & 0xE0) == 224) {
            return (int)int8;
        }
        switch (type) {
            case 192: {
                return null;
            }
            case 194: {
                return false;
            }
            case 195: {
                return true;
            }
            case 196: {
                return MessagePackCodec.bin(inputStream, inputStream.read() & 0xFF);
            }
            case 197: {
                return MessagePackCodec.bin(inputStream, inputStream.readShort() & 0xFFFF);
            }
            case 198: {
                return MessagePackCodec.bin(inputStream, MessagePackCodec.readUnsignedInt(inputStream));
            }
            case 202: {
                return (double)inputStream.readFloat();
            }
            case 203: {
                return inputStream.readDouble();
            }
            case 204: {
                return inputStream.readByte() & 0xFF;
            }
            case 205: {
                return inputStream.readShort() & 0xFFFF;
            }
            case 206: {
                return MessagePackCodec.readUnsignedInt(inputStream);
            }
            case 208: {
                return (int)inputStream.readByte();
            }
            case 209: {
                return (int)inputStream.readShort();
            }
            case 210: {
                return inputStream.readInt();
            }
            case 217: {
                return MessagePackCodec.str(inputStream, inputStream.readByte() & 0xFF);
            }
            case 218: {
                return MessagePackCodec.str(inputStream, inputStream.readShort() & 0xFFFF);
            }
            case 219: {
                return MessagePackCodec.str(inputStream, MessagePackCodec.readUnsignedInt(inputStream));
            }
            case 220: {
                return MessagePackCodec.array(inputStream, inputStream.readShort() & 0xFFFF);
            }
            case 221: {
                return MessagePackCodec.array(inputStream, MessagePackCodec.readUnsignedInt(inputStream));
            }
            case 222: {
                return MessagePackCodec.map(inputStream, inputStream.readShort() & 0xFFFF);
            }
            case 223: {
                return MessagePackCodec.map(inputStream, MessagePackCodec.readUnsignedInt(inputStream));
            }
        }
        throw new IllegalArgumentException("Unknown MessagePack type 0x" + type);
    }

    private static int readUnsignedInt(DataInputStream inputStream) throws IOException {
        return (int)((long)inputStream.readInt() & 0xFFFFFFFFL);
    }

    private static Map<String, Object> map(DataInputStream inputStream, int length) throws IOException {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        for (int i = 0; i < length; ++i) {
            value.put((String)MessagePackCodec.decodeInternal(inputStream), MessagePackCodec.decodeInternal(inputStream));
        }
        return value;
    }

    private static byte[] bin(DataInputStream inputStream, int length) throws IOException {
        byte[] tmp = new byte[length];
        inputStream.readFully(tmp);
        return tmp;
    }

    private static String str(DataInputStream inputStream, int length) throws IOException {
        return new String(MessagePackCodec.bin(inputStream, length), StandardCharsets.US_ASCII);
    }

    private static Object[] array(DataInputStream inputStream, int length) throws IOException {
        Object[] value = new Object[length];
        for (int i = 0; i < length; ++i) {
            value[i] = MessagePackCodec.decodeInternal(inputStream);
        }
        return value;
    }
}

