/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rcsb.cif.binary.data.IntArray;
import org.rcsb.cif.binary.data.SignedIntArray;
import org.rcsb.cif.binary.encoding.Encoding;

public class DeltaEncoding<T extends SignedIntArray<?>>
implements Encoding<T, T> {
    private int origin;
    private int srcType;

    public DeltaEncoding() {
    }

    public DeltaEncoding(int origin, int srcType) {
        this.origin = origin;
        this.srcType = srcType;
    }

    @Override
    public Map<String, Object> getMapRepresentation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("kind", "Delta");
        map.put("origin", this.origin);
        map.put("srcType", this.srcType);
        return map;
    }

    @Override
    public T decode(T data) {
        int[] input = data.getData();
        SignedIntArray output = (SignedIntArray)IntArray.create(data.getType(), input.length);
        output.setEncoding(data.getEncoding());
        int n = input.length;
        if (n == 0) {
            return (T)output;
        }
        int[] outputArray = output.getData();
        outputArray[0] = input[0] + this.origin;
        for (int i = 1; i < n; ++i) {
            outputArray[i] = input[i] + outputArray[i - 1];
        }
        return (T)output;
    }

    @Override
    public T encode(T data) {
        int srcType = data.getType();
        int[] inputArray = data.getData();
        if (inputArray.length == 0) {
            SignedIntArray output = (SignedIntArray)IntArray.create(srcType, 0);
            return (T)this.create(data, srcType, output, 0);
        }
        SignedIntArray output = (SignedIntArray)IntArray.create(srcType, inputArray.length);
        int[] outputArray = output.getData();
        int origin = inputArray[0];
        outputArray[0] = inputArray[0];
        for (int i = 1; i < inputArray.length; ++i) {
            outputArray[i] = inputArray[i] - inputArray[i - 1];
        }
        outputArray[0] = 0;
        return (T)this.create(data, srcType, output, origin);
    }

    private T create(T data, int srcType, T output, int origin) {
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        this.origin = origin;
        this.srcType = srcType;
        enc.add(this);
        output.setEncoding(enc);
        return output;
    }

    public String toString() {
        return "DeltaEncoding{origin=" + this.origin + ", srcType=" + this.srcType + '}';
    }
}

