/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.encoder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.rcsb.mmtf.api.StructureAdapterInterface;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.dataholders.BioAssemblyData;
import org.rcsb.mmtf.dataholders.BioAssemblyTransformation;
import org.rcsb.mmtf.dataholders.Entity;
import org.rcsb.mmtf.dataholders.Group;
import org.rcsb.mmtf.utils.CodecUtils;

public class AdapterToStructureData
implements StructureDataInterface,
StructureAdapterInterface,
Serializable {
    private static final long serialVersionUID = 4984676010601174880L;
    private float[] cartnX;
    private float[] cartnY;
    private float[] cartnZ;
    private float[] bFactor;
    private float[] occupancy;
    private int[] atomId;
    private char[] altId;
    private char[] insertionCodeList;
    private int[] groupNum;
    private List<Group> groupMap;
    private int[] groupList;
    private int[] seqResGroupList;
    private String[] publicChainIds;
    private int[] chainsPerModel;
    private int[] groupsPerChain;
    private String spaceGroup;
    private float[] unitCell;
    private List<BioAssemblyData> bioAssembly;
    private List<Integer> interGroupBondIndices;
    private List<Integer> interGroupBondOrders;
    private String[] chainList;
    private String mmtfVersion = "1.0.0";
    private String mmtfProducer = "UNKNOWN";
    private Entity[] entityList;
    private String pdbId;
    private Float resolution;
    private Float rFree;
    private Float rWork;
    private String title;
    private String[] experimentalMethods;
    private String depositionDate;
    private String releaseDate;
    private int numModels;
    private int[] secStructInfo;
    private int atomIndex = 0;
    private int groupAtomIndex = 0;
    private int groupBondIndex = 0;
    private int groupIndex = 0;
    private int chainIndex = 0;
    private int modelIndex = 0;
    private Group pdbGroup;
    private int totalNumBonds;
    private List<Group> pdbGroupList;
    private double[][] ncsOperMatrixList;
    private transient List<Entity> entities;

    public float[] getxCoords() {
        return this.cartnX;
    }

    public float[] getyCoords() {
        return this.cartnY;
    }

    public float[] getzCoords() {
        return this.cartnZ;
    }

    public float[] getbFactors() {
        return this.bFactor;
    }

    public float[] getOccupancies() {
        return this.occupancy;
    }

    public int[] getAtomIds() {
        return this.atomId;
    }

    public char[] getAltLocIds() {
        return this.altId;
    }

    public char[] getInsCodes() {
        return this.insertionCodeList;
    }

    public int[] getGroupIds() {
        return this.groupNum;
    }

    public String getGroupName(int groupInd) {
        return this.getGroup(groupInd).getGroupName();
    }

    public int getNumAtomsInGroup(int groupInd) {
        return this.getGroup(groupInd).getFormalChargeList().length;
    }

    public String[] getGroupAtomNames(int groupInd) {
        return this.getGroup(groupInd).getAtomNameList();
    }

    public String[] getGroupElementNames(int groupInd) {
        return this.getGroup(groupInd).getElementList();
    }

    public int[] getGroupBondOrders(int groupInd) {
        return this.getGroup(groupInd).getBondOrderList();
    }

    public int[] getGroupBondIndices(int groupInd) {
        return this.getGroup(groupInd).getBondAtomList();
    }

    public int[] getGroupAtomCharges(int groupInd) {
        return this.getGroup(groupInd).getFormalChargeList();
    }

    public char getGroupSingleLetterCode(int groupInd) {
        return this.getGroup(groupInd).getSingleLetterCode();
    }

    public String getGroupChemCompType(int groupInd) {
        return this.getGroup(groupInd).getChemCompType();
    }

    public int[] getGroupTypeIndices() {
        return this.groupList;
    }

    public int[] getGroupSequenceIndices() {
        return this.seqResGroupList;
    }

    public String[] getChainIds() {
        return this.chainList;
    }

    public String[] getChainNames() {
        return this.publicChainIds;
    }

    public int[] getChainsPerModel() {
        return this.chainsPerModel;
    }

    public int[] getGroupsPerChain() {
        return this.groupsPerChain;
    }

    public String getSpaceGroup() {
        return this.spaceGroup;
    }

    public float[] getUnitCell() {
        return this.unitCell;
    }

    public int getNumBioassemblies() {
        return this.bioAssembly.size();
    }

    public int getNumTransInBioassembly(int bioassemblyIndex) {
        return this.bioAssembly.get(bioassemblyIndex).getTransformList().size();
    }

    public int[] getChainIndexListForTransform(int bioassemblyIndex, int transformationIndex) {
        return ((BioAssemblyTransformation)this.bioAssembly.get(bioassemblyIndex).getTransformList().get(transformationIndex)).getChainIndexList();
    }

    public double[] getMatrixForTransform(int bioassemblyIndex, int transformationIndex) {
        return ((BioAssemblyTransformation)this.bioAssembly.get(bioassemblyIndex).getTransformList().get(transformationIndex)).getMatrix();
    }

    public int[] getInterGroupBondIndices() {
        return CodecUtils.convertToIntArray(this.interGroupBondIndices);
    }

    public int[] getInterGroupBondOrders() {
        return CodecUtils.convertToIntArray(this.interGroupBondOrders);
    }

    public String getMmtfVersion() {
        return this.mmtfVersion;
    }

    public String getMmtfProducer() {
        return this.mmtfProducer;
    }

    public int getNumEntities() {
        return this.entityList.length;
    }

    public String getEntityDescription(int entityInd) {
        return this.entityList[entityInd].getDescription();
    }

    public String getEntityType(int entityInd) {
        return this.entityList[entityInd].getType();
    }

    public int[] getEntityChainIndexList(int entityInd) {
        return this.entityList[entityInd].getChainIndexList();
    }

    public String getEntitySequence(int entityInd) {
        return this.entityList[entityInd].getSequence();
    }

    public String getStructureId() {
        return this.pdbId;
    }

    public int getNumModels() {
        return this.numModels;
    }

    public int getNumChains() {
        int sum = 0;
        for (int numChainsInModel : this.chainsPerModel) {
            sum += numChainsInModel;
        }
        return sum;
    }

    public int getNumGroups() {
        return this.insertionCodeList.length;
    }

    public int getNumAtoms() {
        return this.cartnX.length;
    }

    public float getRfree() {
        return this.rFree.floatValue();
    }

    public float getRwork() {
        return this.rWork.floatValue();
    }

    public float getResolution() {
        return this.resolution.floatValue();
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getExperimentalMethods() {
        return this.experimentalMethods;
    }

    public String getDepositionDate() {
        return this.depositionDate;
    }

    public void initStructure(int totalNumBonds, int totalNumAtoms, int totalNumGroups, int totalNumChains, int totalNumModels, String structureId) {
        this.totalNumBonds = totalNumBonds;
        this.interGroupBondIndices = new ArrayList<Integer>();
        this.interGroupBondOrders = new ArrayList<Integer>();
        this.cartnX = new float[totalNumAtoms];
        this.cartnY = new float[totalNumAtoms];
        this.cartnZ = new float[totalNumAtoms];
        this.occupancy = new float[totalNumAtoms];
        this.bFactor = new float[totalNumAtoms];
        this.atomId = new int[totalNumAtoms];
        this.altId = new char[totalNumAtoms];
        this.groupNum = new int[totalNumGroups];
        this.insertionCodeList = new char[totalNumGroups];
        this.seqResGroupList = new int[totalNumGroups];
        this.secStructInfo = new int[totalNumGroups];
        this.pdbGroupList = new ArrayList<Group>();
        this.chainList = new String[totalNumChains];
        this.publicChainIds = new String[totalNumChains];
        this.groupsPerChain = new int[totalNumChains];
        this.numModels = totalNumModels;
        this.pdbId = structureId;
        this.bioAssembly = new ArrayList<BioAssemblyData>();
        this.chainsPerModel = new int[totalNumModels];
        this.entities = new ArrayList<Entity>();
    }

    public void finalizeStructure() {
        this.entityList = this.entities.toArray(new Entity[0]);
        this.entities.clear();
        this.groupMap = new ArrayList<Group>(new HashSet<Group>(this.pdbGroupList));
        this.groupList = new int[this.pdbGroupList.size()];
        for (int i = 0; i < this.pdbGroupList.size(); ++i) {
            this.groupList[i] = this.groupMap.indexOf(this.pdbGroupList.get(i));
        }
    }

    public void setModelInfo(int modelId, int chainCount) {
        this.chainsPerModel[this.modelIndex] = chainCount;
        ++this.modelIndex;
    }

    public void setChainInfo(String chainId, String chainName, int groupCount) {
        this.chainList[this.chainIndex] = chainId;
        this.publicChainIds[this.chainIndex] = chainName;
        this.groupsPerChain[this.chainIndex] = groupCount;
        ++this.chainIndex;
    }

    public void setEntityInfo(int[] chainIndices, String sequence, String description, String title) {
        Entity entity = new Entity();
        entity.setChainIndexList(chainIndices);
        entity.setSequence(sequence);
        entity.setDescription(description);
        entity.setType(title);
        this.entities.add(entity);
    }

    public void setGroupInfo(String groupName, int groupNumber, char insertionCode, String polymerType, int atomCount, int bondCount, char singleAtomCode, int sequenceIndex, int secStructType) {
        this.pdbGroup = new Group();
        this.pdbGroupList.add(this.pdbGroup);
        this.pdbGroup.setFormalChargeList(new int[atomCount]);
        this.pdbGroup.setAtomNameList(new String[atomCount]);
        this.pdbGroup.setBondAtomList(new int[bondCount * 2]);
        this.pdbGroup.setBondOrderList(new int[bondCount]);
        this.pdbGroup.setChemCompType(polymerType);
        this.pdbGroup.setElementList(new String[atomCount]);
        this.pdbGroup.setGroupName(groupName);
        this.pdbGroup.setSingleLetterCode(singleAtomCode);
        this.groupAtomIndex = 0;
        this.groupBondIndex = 0;
        this.insertionCodeList[this.groupIndex] = insertionCode;
        this.groupNum[this.groupIndex] = groupNumber;
        this.seqResGroupList[this.groupIndex] = sequenceIndex;
        this.secStructInfo[this.groupIndex] = secStructType;
        ++this.groupIndex;
    }

    public void setAtomInfo(String atomName, int serialNumber, char alternativeLocationId, float x, float y, float z, float occupancy, float temperatureFactor, String element, int charge) {
        this.pdbGroup.getFormalChargeList()[this.groupAtomIndex] = charge;
        this.pdbGroup.getAtomNameList()[this.groupAtomIndex] = atomName;
        this.pdbGroup.getElementList()[this.groupAtomIndex] = element;
        this.cartnX[this.atomIndex] = x;
        this.cartnY[this.atomIndex] = y;
        this.cartnZ[this.atomIndex] = z;
        this.occupancy[this.atomIndex] = occupancy;
        this.bFactor[this.atomIndex] = temperatureFactor;
        this.atomId[this.atomIndex] = serialNumber;
        this.altId[this.atomIndex] = alternativeLocationId;
        ++this.groupAtomIndex;
        ++this.atomIndex;
    }

    public void setBioAssemblyTrans(int bioAssemblyIndex, int[] chainIndices, double[] transform, String name) {
        BioAssemblyData bioAssemblyData;
        if (this.bioAssembly.size() > bioAssemblyIndex) {
            bioAssemblyData = this.bioAssembly.get(bioAssemblyIndex);
        } else {
            bioAssemblyData = new BioAssemblyData(name);
            this.bioAssembly.add(bioAssemblyData);
        }
        BioAssemblyTransformation bioAssemblyTrans = new BioAssemblyTransformation();
        bioAssemblyTrans.setChainIndexList(chainIndices);
        bioAssemblyTrans.setMatrix(transform);
        bioAssemblyData.getTransformList().add(bioAssemblyTrans);
    }

    public void setXtalInfo(String spaceGroup, float[] unitCell, double[][] ncsOperMatrixList) {
        this.spaceGroup = spaceGroup;
        this.unitCell = unitCell;
        this.ncsOperMatrixList = ncsOperMatrixList;
    }

    public void setGroupBond(int firstAtomIndex, int secondAtomIndex, int bondOrder) {
        this.pdbGroup.getBondAtomList()[this.groupBondIndex * 2] = firstAtomIndex;
        this.pdbGroup.getBondAtomList()[this.groupBondIndex * 2 + 1] = secondAtomIndex;
        this.pdbGroup.getBondOrderList()[this.groupBondIndex] = bondOrder;
        ++this.groupBondIndex;
    }

    public void setInterGroupBond(int firstAtomIndex, int secondAtomIndex, int bondOrder) {
        this.interGroupBondIndices.add(firstAtomIndex);
        this.interGroupBondIndices.add(secondAtomIndex);
        this.interGroupBondOrders.add(bondOrder);
    }

    public void setHeaderInfo(float rFree, float rWork, float resolution, String title, String depositionDate, String releaseDate, String[] experimnetalMethods) {
        this.rFree = Float.valueOf(rFree);
        this.rWork = Float.valueOf(rWork);
        this.resolution = Float.valueOf(resolution);
        this.title = title;
        this.depositionDate = depositionDate;
        this.releaseDate = releaseDate;
        this.experimentalMethods = experimnetalMethods;
    }

    public void setMmtfProducer(String mmtfProducer) {
        this.mmtfProducer = mmtfProducer;
    }

    private Group getGroup(int groupInd) {
        return this.groupMap.get(groupInd);
    }

    public int getNumBonds() {
        return this.totalNumBonds;
    }

    public int[] getSecStructList() {
        return this.secStructInfo;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public double[][] getNcsOperatorList() {
        return this.ncsOperMatrixList;
    }

    public String getBioassemblyName(int bioassemblyIndex) {
        return this.bioAssembly.get(bioassemblyIndex).getName();
    }
}

