/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;
import org.rcsb.mmtf.encoder.AdapterToStructureData;
import org.rcsb.mmtf.encoder.GenericEncoder;
import org.rcsb.mmtf.serialization.MessagePackSerialization;

public class WriterUtils {
    public static void writeDataToFile(AdapterToStructureData writerToEncoder, Path path) throws IOException {
        byte[] byteArray = WriterUtils.getDataAsByteArr(writerToEncoder);
        OutputStream fos = Files.newOutputStream(path, new OpenOption[0]);
        fos.write(byteArray);
        fos.close();
    }

    public static byte[] getDataAsByteArr(AdapterToStructureData writerToEncoder) throws IOException {
        MessagePackSerialization mmtfBeanSeDerializerInterface = new MessagePackSerialization();
        GenericEncoder genericEncoder = new GenericEncoder(writerToEncoder);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        mmtfBeanSeDerializerInterface.serialize(genericEncoder.getMmtfEncodedStructure(), (OutputStream)bos);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzipCompress(byte[] byteArray) throws IOException {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(byteArray.length);
             GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
            zipStream.write(byteArray);
        }
        return byteStream.toByteArray();
    }
}

