/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.rcsb.mmtf.dataholders.MmtfStructure;
import org.rcsb.mmtf.dataholders.MmtfStructureFactory;
import org.rcsb.mmtf.serialization.MmtfStructureSerializationInterface;
import org.rcsb.mmtf.serialization.quickmessagepackdeserialization.MessagePackReader;
import org.rcsb.mmtf.serialization.quickmessagepackdeserialization.ObjectTree;

public class MessagePackSerialization
implements MmtfStructureSerializationInterface {
    private ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
    private static boolean useJackson = false;

    public MessagePackSerialization() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static void setJackson(boolean allowed) {
        useJackson = allowed;
    }

    @Override
    public MmtfStructure deserialize(InputStream inputStream) throws IOException {
        if (useJackson) {
            return this.deserializeByJackson(inputStream);
        }
        return this.deserializeQuick(inputStream);
    }

    private MmtfStructure deserializeByJackson(InputStream inputStream) throws IOException {
        return (MmtfStructure)this.objectMapper.readValue(inputStream, MmtfStructure.class);
    }

    private MmtfStructure deserializeQuick(InputStream inputStream) throws IOException {
        MessagePackReader mpr = new MessagePackReader(new DataInputStream(inputStream), true);
        Map<String, Object> map = mpr.readMap();
        MmtfStructureFactory f = new MmtfStructureFactory();
        MmtfStructure s = f.create(new ObjectTree(map));
        return s;
    }

    @Override
    public void serialize(MmtfStructure mmtfStructure, OutputStream outputStream) throws IOException {
        this.objectMapper.writeValue(outputStream, (Object)mmtfStructure);
    }
}

