/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.serialization.quickmessagepackdeserialization;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

public class MessagePackReader {
    private final boolean isHomo;
    private static final int POSITIVEFIXINT_x80 = 128;
    private static final int FIXMAP_xF0 = 128;
    private static final int FIXSTR_xE0 = 160;
    private static final int NEGATIVEFIXINT_xE0 = 224;
    private static final int DEFINITE_xE0 = 192;
    private static final int NIL = 192;
    private static final int FALSE = 194;
    private static final int TRUE = 195;
    private static final int BIN8 = 196;
    private static final int BIN16 = 197;
    private static final int BIN32 = 198;
    private static final int EXT8 = 199;
    private static final int EXT16 = 200;
    private static final int EXT32 = 201;
    private static final int FLOAT32 = 202;
    private static final int FLOAT64 = 203;
    private static final int UINT8 = 204;
    private static final int UINT16 = 205;
    private static final int UINT32 = 206;
    private static final int UINT64 = 207;
    private static final int INT8 = 208;
    private static final int INT16 = 209;
    private static final int INT32 = 210;
    private static final int INT64 = 211;
    private static final int FIXEXT1 = 212;
    private static final int FIXEXT2 = 213;
    private static final int FIXEXT4 = 214;
    private static final int FIXEXT8 = 215;
    private static final int FIXEXT16 = 216;
    private static final int STR8 = 217;
    private static final int STR16 = 218;
    private static final int STR32 = 219;
    private static final int ARRAY16 = 220;
    private static final int ARRAY32 = 221;
    private static final int MAP16 = 222;
    private static final int MAP32 = 223;
    private final DataInputStream stream;
    private final boolean isBigEndian = true;
    private final byte[] t8 = new byte[8];

    public MessagePackReader(DataInputStream dis, boolean isHomogeneousArrays) {
        this.isHomo = isHomogeneousArrays;
        this.stream = dis;
    }

    public Map<String, Object> readMap() throws IOException {
        return (Map)this.getNext(null, 0);
    }

    private Object getNext(Object array, int pt) throws IOException {
        int b = this.readByte() & 0xFF;
        int be0 = b & 0xE0;
        if ((b & 0x80) == 0) {
            if (array != null) {
                ((int[])array)[pt] = b;
                return null;
            }
            return b;
        }
        block0 : switch (be0) {
            case 224: {
                b |= 0xFFFFFF00;
                if (array != null) {
                    ((int[])array)[pt] = b;
                    return null;
                }
                return b;
            }
            case 160: {
                String s = this.readString(b & 0x1F);
                if (array != null) {
                    ((String[])array)[pt] = s;
                    return null;
                }
                return s;
            }
            case 128: {
                return (b & 0xF0) == 128 ? this.getMap(b & 0xF) : this.getArray(b & 0xF);
            }
            case 192: {
                switch (b) {
                    case 192: {
                        return null;
                    }
                    case 194: {
                        return Boolean.FALSE;
                    }
                    case 195: {
                        return Boolean.TRUE;
                    }
                    case 199: {
                        int n = this.readUInt8();
                        return new Object[]{this.readUInt8(), this.readBytes(n)};
                    }
                    case 200: {
                        int n = this.readUnsignedShort();
                        return new Object[]{this.readUInt8(), this.readBytes(n)};
                    }
                    case 201: {
                        int n = this.readInt();
                        return new Object[]{this.readUInt8(), this.readBytes(n)};
                    }
                    case 212: {
                        return new Object[]{this.readUInt8(), this.readBytes(1)};
                    }
                    case 213: {
                        return new Object[]{this.readUInt8(), this.readBytes(2)};
                    }
                    case 214: {
                        return new Object[]{this.readUInt8(), this.readBytes(4)};
                    }
                    case 215: {
                        return new Object[]{this.readUInt8(), this.readBytes(8)};
                    }
                    case 216: {
                        return new Object[]{this.readUInt8(), this.readBytes(16)};
                    }
                    case 220: {
                        return this.getArray(this.readUnsignedShort());
                    }
                    case 221: {
                        return this.getArray(this.readInt());
                    }
                    case 222: {
                        return this.getMap(this.readUnsignedShort());
                    }
                    case 223: {
                        return this.getMap(this.readInt());
                    }
                    case 196: {
                        return this.readBytes(this.readUInt8());
                    }
                    case 197: {
                        return this.readBytes(this.readUnsignedShort());
                    }
                    case 198: {
                        return this.readBytes(this.readInt());
                    }
                }
                if (array == null) {
                    switch (b) {
                        case 202: {
                            return Float.valueOf(this.readFloat());
                        }
                        case 203: {
                            return this.readDouble();
                        }
                        case 204: {
                            return this.readUInt8();
                        }
                        case 205: {
                            return this.readUnsignedShort();
                        }
                        case 206: {
                            return this.readInt();
                        }
                        case 207: {
                            return this.readLong();
                        }
                        case 208: {
                            return this.readByte();
                        }
                        case 209: {
                            return this.readShort();
                        }
                        case 210: {
                            return this.readInt();
                        }
                        case 211: {
                            return this.readLong();
                        }
                        case 217: {
                            return this.readString(this.readUInt8());
                        }
                        case 218: {
                            return this.readString(this.readShort());
                        }
                        case 219: {
                            return this.readString(this.readInt());
                        }
                    }
                    break;
                }
                switch (b) {
                    case 202: {
                        ((float[])array)[pt] = this.readFloat();
                        break block0;
                    }
                    case 203: {
                        ((double[])array)[pt] = this.readDouble();
                        break block0;
                    }
                    case 204: {
                        ((int[])array)[pt] = this.readUInt8();
                        break block0;
                    }
                    case 205: {
                        ((int[])array)[pt] = this.readUnsignedShort();
                        break block0;
                    }
                    case 206: {
                        ((int[])array)[pt] = this.readInt();
                        break block0;
                    }
                    case 207: {
                        ((int[])array)[pt] = (int)this.readLong();
                        break block0;
                    }
                    case 208: {
                        ((int[])array)[pt] = this.readByte();
                        break block0;
                    }
                    case 209: {
                        ((int[])array)[pt] = this.readShort();
                        break block0;
                    }
                    case 210: {
                        ((int[])array)[pt] = this.readInt();
                        break block0;
                    }
                    case 211: {
                        ((int[])array)[pt] = (int)this.readLong();
                        break block0;
                    }
                    case 217: {
                        ((String[])array)[pt] = this.readString(this.readUInt8());
                        break block0;
                    }
                    case 218: {
                        ((String[])array)[pt] = this.readString(this.readShort());
                        break block0;
                    }
                    case 219: {
                        ((String[])array)[pt] = this.readString(this.readInt());
                    }
                }
            }
        }
        return null;
    }

    private Object getArray(int n) throws IOException {
        if (this.isHomo) {
            Object[] a;
            if (n == 0) {
                return null;
            }
            Object v = this.getNext(null, 0);
            if (v instanceof Integer) {
                a = new int[n];
                a[0] = (Integer)v;
                v = a;
            } else if (v instanceof Float) {
                a = new float[n];
                a[0] = (int)((Float)v).floatValue();
                v = a;
            } else if (v instanceof Double) {
                a = new double[n];
                a[0] = (int)((Double)v).doubleValue();
                v = a;
            } else if (v instanceof String) {
                a = new String[n];
                a[0] = (int)((String)v);
                v = a;
            } else {
                Object[] o = new Object[n];
                o[0] = v;
                for (int i = 1; i < n; ++i) {
                    o[i] = this.getNext(null, 0);
                }
                return o;
            }
            for (int i = 1; i < n; ++i) {
                this.getNext(v, i);
            }
            return v;
        }
        Object[] o = new Object[n];
        for (int i = 0; i < n; ++i) {
            o[i] = this.getNext(null, 0);
        }
        return o;
    }

    private Object getMap(int n) throws IOException {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        for (int i = 0; i < n; ++i) {
            String key = this.getNext(null, 0).toString();
            Object value = this.getNext(null, 0);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private byte readByte() throws IOException {
        return this.ioReadByte();
    }

    private byte ioReadByte() throws IOException {
        byte b = this.stream.readByte();
        return b;
    }

    private int readUInt8() throws IOException {
        int b = this.stream.readUnsignedByte();
        return b;
    }

    private byte[] readBytes(int n) throws IOException {
        byte[] b = new byte[n];
        this.readByteArray(b, 0, n);
        return b;
    }

    private int readByteArray(byte[] b, int off, int len) throws IOException {
        int n = this.ioRead(b, off, len);
        return n;
    }

    private int ioRead(byte[] b, int off, int len) throws IOException {
        int m = 0;
        while (len > 0) {
            int n = this.stream.read(b, off, len);
            m += n;
            if (n >= len) break;
            off += n;
            len -= n;
        }
        return m;
    }

    private String readString(int nChar) throws IOException {
        byte[] temp = new byte[nChar];
        int n = this.readByteArray(temp, 0, nChar);
        return new String(temp, 0, n, "UTF-8");
    }

    private short readShort() throws IOException {
        return this.ioReadShort();
    }

    private short ioReadShort() throws IOException {
        return this.stream.readShort();
    }

    private int readInt() throws IOException {
        return this.ioReadInt();
    }

    private int ioReadInt() throws IOException {
        int i = this.stream.readInt();
        return i;
    }

    private int readUnsignedShort() throws IOException {
        int a = this.ioReadByte() & 0xFF;
        int b = this.ioReadByte() & 0xFF;
        return (a << 8) + b;
    }

    private long readLong() throws IOException {
        return this.ioReadLong();
    }

    private long ioReadLong() throws IOException {
        long b = this.stream.readLong();
        return b;
    }

    private int readLEInt() throws IOException {
        this.ioRead(this.t8, 0, 4);
        return MessagePackReader.bytesToInt(this.t8, 0, false);
    }

    private float readFloat() throws IOException {
        return MessagePackReader.intToFloat(this.readInt());
    }

    private double readDouble() throws IOException {
        return this.ioReadDouble();
    }

    private double ioReadDouble() throws IOException {
        double d = this.stream.readDouble();
        return d;
    }

    private long readLELong() throws IOException {
        return (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 56;
    }

    private static int bytesToInt(byte[] bytes, int j, boolean isBigEndian) {
        return isBigEndian ? bytes[j + 3] & 0xFF | (bytes[j + 2] & 0xFF) << 8 | (bytes[j + 1] & 0xFF) << 16 | (bytes[j] & 0xFF) << 24 : bytes[j++] & 0xFF | (bytes[j++] & 0xFF) << 8 | (bytes[j++] & 0xFF) << 16 | (bytes[j++] & 0xFF) << 24;
    }

    private static float intToFloat(int x) {
        return Float.intBitsToFloat(x);
    }
}

