/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.enums;

import java.io.File;

public enum RDFNotation {
    RDFXML,
    NTRIPLES,
    TURTLE,
    N3,
    TAR,
    RAR;


    public static RDFNotation parse(String str) {
        if (str == null || str.isEmpty()) {
            return NTRIPLES;
        }
        if ((str = str.toLowerCase()).equals("ntriples") || str.equals("nt")) {
            return NTRIPLES;
        }
        if (str.equals("n3")) {
            return N3;
        }
        if (str.equals("rdfxml") || str.equals("rdf-xml")) {
            return RDFXML;
        }
        if (str.equals("turtle")) {
            return TURTLE;
        }
        if (str.equals("rar")) {
            return RAR;
        }
        if (str.equals("tar") || str.equals("tgz") || str.equals("tbz") || str.equals("tbz2")) {
            return TAR;
        }
        throw new IllegalArgumentException();
    }

    public static RDFNotation guess(String fileName) throws IllegalArgumentException {
        String ext;
        String str = fileName.toLowerCase();
        int idx = str.lastIndexOf(46);
        if (idx != -1 && ((ext = str.substring(idx + 1, str.length())).equals("gz") || ext.equals("bz") || ext.equals("bz2"))) {
            str = str.substring(0, idx);
        }
        if (str.endsWith("nt")) {
            return NTRIPLES;
        }
        if (str.endsWith("n3")) {
            return N3;
        }
        if (str.endsWith("rdf") || str.endsWith("xml") || str.endsWith("owl")) {
            return RDFXML;
        }
        if (str.endsWith("ttl")) {
            return TURTLE;
        }
        if (str.endsWith("tar") || str.endsWith("tgz") || str.endsWith("tbz2")) {
            return TAR;
        }
        if (str.endsWith("rar")) {
            return RAR;
        }
        throw new IllegalArgumentException("Could not guess the format for " + fileName);
    }

    public static RDFNotation guess(File fileName) throws IllegalArgumentException {
        return RDFNotation.guess(fileName.getName());
    }
}

