/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt;

import java.io.IOException;
import java.io.InputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.IteratorTripleString;

public abstract class HDTManager {
    private static HDTManager instance = null;

    private static HDTManager getInstance() {
        if (instance == null) {
            try {
                Class<?> managerImplClass = Class.forName("org.rdfhdt.hdt.hdt.HDTManagerImpl");
                instance = (HDTManager)managerImplClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class org.rdfhdt.hdt.hdt.HDTManagerImpl not found. Did you include the HDT implementation jar?");
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Cannot create implementation for HDTManager. Does the class org.rdfhdt.hdt.hdt.HDTManagerImpl inherit from HDTManager?");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static HDTOptions readOptions(String file) throws IOException {
        return HDTManager.getInstance().doReadOptions(file);
    }

    public static HDT loadHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doLoadHDT(hdtFileName, listener);
    }

    public static HDT mapHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doMapHDT(hdtFileName, listener);
    }

    public static HDT loadHDT(InputStream hdtFile, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doLoadHDT(hdtFile, listener);
    }

    public static HDT loadIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doLoadIndexedHDT(hdtFileName, listener);
    }

    public static HDT mapIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doMapIndexedHDT(hdtFileName, listener);
    }

    public static HDT loadIndexedHDT(InputStream hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doLoadIndexedHDT(hdtFileName, listener);
    }

    public static HDT indexedHDT(HDT hdt, ProgressListener listener) {
        return HDTManager.getInstance().doIndexedHDT(hdt, listener);
    }

    public static HDT generateHDT(String rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDT(rdfFileName, baseURI, rdfNotation, hdtFormat, listener);
    }

    public static HDT generateHDT(IteratorTripleString iterator, String baseURI, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDT(iterator, baseURI, hdtFormat, listener);
    }

    protected abstract HDTOptions doReadOptions(String var1) throws IOException;

    protected abstract HDT doLoadHDT(String var1, ProgressListener var2) throws IOException;

    protected abstract HDT doLoadHDT(InputStream var1, ProgressListener var2) throws IOException;

    protected abstract HDT doMapHDT(String var1, ProgressListener var2) throws IOException;

    protected abstract HDT doLoadIndexedHDT(String var1, ProgressListener var2) throws IOException;

    protected abstract HDT doLoadIndexedHDT(InputStream var1, ProgressListener var2) throws IOException;

    protected abstract HDT doMapIndexedHDT(String var1, ProgressListener var2) throws IOException;

    protected abstract HDT doIndexedHDT(HDT var1, ProgressListener var2);

    protected abstract HDT doGenerateHDT(String var1, String var2, RDFNotation var3, HDTOptions var4, ProgressListener var5) throws IOException, ParserException;

    protected abstract HDT doGenerateHDT(IteratorTripleString var1, String var2, HDTOptions var3, ProgressListener var4) throws IOException;
}

