/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.io.IOException;

public class UnicodeEscape {
    private static boolean isLetterOrNumber(int c) {
        return UnicodeEscape.isLetter(c) || UnicodeEscape.isNumber(c);
    }

    private static boolean isLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    private static boolean isNumber(int c) {
        return c >= 48 && c <= 57;
    }

    public static String escapeString(String label) {
        try {
            StringBuilder sb = new StringBuilder(2 * label.length());
            UnicodeEscape.escapeString(label, sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static void escapeString(String label, Appendable appendable) throws IOException {
        int i;
        int first = 0;
        int last = label.length();
        if (last > 1 && label.charAt(0) == '<' && label.charAt(last - 1) == '>') {
            ++first;
            --last;
        } else if (label.charAt(0) == '\"') {
            first = 1;
            appendable.append('\"');
            for (i = last - 1; i > 0; --i) {
                char curr = label.charAt(i);
                if (curr == '\"') {
                    last = i;
                    break;
                }
                char prev = label.charAt(i - 1);
                if (curr == '@' && prev == '\"') {
                    last = i - 2;
                    break;
                }
                if (curr != '^' || prev != '^') continue;
                last = i - 2;
                break;
            }
        }
        for (i = first; i < last; ++i) {
            char c;
            char cInt = c = label.charAt(i);
            if (c == '\\') {
                appendable.append("\\\\");
                continue;
            }
            if (c == '\"') {
                appendable.append("\\\"");
                continue;
            }
            if (c == '\n') {
                appendable.append("\\n");
                continue;
            }
            if (c == '\r') {
                appendable.append("\\r");
                continue;
            }
            if (c == '\t') {
                appendable.append("\\t");
                continue;
            }
            if (cInt >= '\u0000' && cInt <= '\b' || cInt == '\u000b' || cInt == '\f' || cInt >= '\u000e' && cInt <= '\u001f' || cInt >= '\u007f' && cInt <= '\uffff') {
                appendable.append("\\u");
                appendable.append(UnicodeEscape.toHexString(cInt, 4));
                continue;
            }
            if (cInt >= '\u10000' && cInt <= '\u10ffff') {
                appendable.append("\\U");
                appendable.append(UnicodeEscape.toHexString(cInt, 8));
                continue;
            }
            appendable.append(c);
        }
        appendable.append(label.subSequence(last, label.length()));
    }

    public static String unescapeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            String xx;
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }

    public static String toHexString(int decimal, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        String hexVal = Integer.toHexString(decimal).toUpperCase();
        int nofZeros = stringLength - hexVal.length();
        for (int i = 0; i < nofZeros; ++i) {
            sb.append('0');
        }
        sb.append(hexVal);
        return sb.toString();
    }
}

