/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.api;

import io.cloudevents.CloudEvent;
import java.lang.reflect.ParameterizedType;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.reactivecommons.api.domain.RawMessage;
import org.reactivecommons.async.api.handlers.CloudCommandHandler;
import org.reactivecommons.async.api.handlers.CloudEventHandler;
import org.reactivecommons.async.api.handlers.DomainCommandHandler;
import org.reactivecommons.async.api.handlers.DomainEventHandler;
import org.reactivecommons.async.api.handlers.QueryHandler;
import org.reactivecommons.async.api.handlers.QueryHandlerDelegate;
import org.reactivecommons.async.api.handlers.RawCommandHandler;
import org.reactivecommons.async.api.handlers.RawEventHandler;
import org.reactivecommons.async.api.handlers.registered.RegisteredCommandHandler;
import org.reactivecommons.async.api.handlers.registered.RegisteredDomainHandlers;
import org.reactivecommons.async.api.handlers.registered.RegisteredEventListener;
import org.reactivecommons.async.api.handlers.registered.RegisteredQueryHandler;

public final class HandlerRegistry {
    public static final String DEFAULT_DOMAIN = "app";
    private final RegisteredDomainHandlers<RegisteredEventListener<?, ?>> domainEventListeners = new RegisteredDomainHandlers();
    private final RegisteredDomainHandlers<RegisteredEventListener<?, ?>> dynamicEventHandlers = new RegisteredDomainHandlers();
    private final RegisteredDomainHandlers<RegisteredEventListener<?, ?>> eventNotificationListener = new RegisteredDomainHandlers();
    private final RegisteredDomainHandlers<RegisteredQueryHandler<?, ?>> handlers = new RegisteredDomainHandlers();
    private final RegisteredDomainHandlers<RegisteredCommandHandler<?, ?>> commandHandlers = new RegisteredDomainHandlers();

    public static HandlerRegistry register() {
        HandlerRegistry instance = new HandlerRegistry();
        instance.domainEventListeners.put(DEFAULT_DOMAIN, new CopyOnWriteArrayList());
        return instance;
    }

    public <T> HandlerRegistry listenEvent(String eventName, DomainEventHandler<T> handler, Class<T> eventClass) {
        return this.listenDomainEvent(DEFAULT_DOMAIN, eventName, handler, eventClass);
    }

    public <T> HandlerRegistry listenDomainEvent(String domain, String eventName, DomainEventHandler<T> handler, Class<T> eventClass) {
        this.domainEventListeners.add(domain, new RegisteredEventListener<T, T>(eventName, handler, eventClass));
        return this;
    }

    public HandlerRegistry listenCloudEvent(String eventName, CloudEventHandler handler) {
        return this.listenDomainCloudEvent(DEFAULT_DOMAIN, eventName, handler);
    }

    public HandlerRegistry listenDomainCloudEvent(String domain, String eventName, CloudEventHandler handler) {
        this.domainEventListeners.add(domain, new RegisteredEventListener<CloudEvent, CloudEvent>(eventName, handler, CloudEvent.class));
        return this;
    }

    public HandlerRegistry listenRawEvent(String eventName, RawEventHandler<?> handler) {
        return this.listenDomainRawEvent(DEFAULT_DOMAIN, eventName, handler);
    }

    public HandlerRegistry listenDomainRawEvent(String domain, String eventName, RawEventHandler<?> handler) {
        this.domainEventListeners.add(domain, new RegisteredEventListener(eventName, handler, RawMessage.class));
        return this;
    }

    public <T> HandlerRegistry listenNotificationEvent(String eventName, DomainEventHandler<T> handler, Class<T> eventClass) {
        return this.listenNotificationEvent(DEFAULT_DOMAIN, eventName, handler, eventClass);
    }

    public <T> HandlerRegistry listenNotificationEvent(String domain, String eventName, DomainEventHandler<T> handler, Class<T> eventClass) {
        this.eventNotificationListener.add(domain, new RegisteredEventListener<T, T>(eventName, handler, eventClass));
        return this;
    }

    public HandlerRegistry listenNotificationCloudEvent(String eventName, CloudEventHandler handler) {
        return this.listenNotificationCloudEvent(DEFAULT_DOMAIN, eventName, handler);
    }

    public HandlerRegistry listenNotificationCloudEvent(String domain, String eventName, CloudEventHandler handler) {
        this.eventNotificationListener.add(domain, new RegisteredEventListener<CloudEvent, CloudEvent>(eventName, handler, CloudEvent.class));
        return this;
    }

    public HandlerRegistry listenNotificationRawEvent(String eventName, RawEventHandler<?> handler) {
        return this.listenNotificationRawEvent(DEFAULT_DOMAIN, eventName, handler);
    }

    public HandlerRegistry listenNotificationRawEvent(String domain, String eventName, RawEventHandler<?> handler) {
        this.eventNotificationListener.add(domain, new RegisteredEventListener(eventName, handler, RawMessage.class));
        return this;
    }

    public <T> HandlerRegistry handleDynamicEvents(String eventNamePattern, DomainEventHandler<T> handler, Class<T> eventClass) {
        this.dynamicEventHandlers.add(DEFAULT_DOMAIN, new RegisteredEventListener<T, T>(eventNamePattern, handler, eventClass));
        return this;
    }

    public HandlerRegistry handleDynamicCloudEvents(String eventNamePattern, CloudEventHandler handler) {
        this.dynamicEventHandlers.add(DEFAULT_DOMAIN, new RegisteredEventListener<CloudEvent, CloudEvent>(eventNamePattern, handler, CloudEvent.class));
        return this;
    }

    public <T> HandlerRegistry handleCommand(String commandName, DomainCommandHandler<T> fn, Class<T> commandClass) {
        return this.handleCommand(DEFAULT_DOMAIN, commandName, fn, commandClass);
    }

    public <T> HandlerRegistry handleCommand(String domain, String commandName, DomainCommandHandler<T> fn, Class<T> commandClass) {
        this.commandHandlers.add(domain, new RegisteredCommandHandler<T, T>(commandName, fn, commandClass));
        return this;
    }

    public HandlerRegistry handleCloudEventCommand(String commandName, CloudCommandHandler handler) {
        return this.handleCloudEventCommand(DEFAULT_DOMAIN, commandName, handler);
    }

    public HandlerRegistry handleCloudEventCommand(String domain, String commandName, CloudCommandHandler handler) {
        this.commandHandlers.add(domain, new RegisteredCommandHandler<CloudEvent, CloudEvent>(commandName, handler, CloudEvent.class));
        return this;
    }

    public HandlerRegistry handleRawCommand(String commandName, RawCommandHandler<?> handler) {
        return this.handleRawCommand(DEFAULT_DOMAIN, commandName, handler);
    }

    public HandlerRegistry handleRawCommand(String domain, String commandName, RawCommandHandler<?> handler) {
        this.commandHandlers.add(domain, new RegisteredCommandHandler(commandName, handler, RawMessage.class));
        return this;
    }

    public <T, R> HandlerRegistry serveQuery(String resource, QueryHandler<T, R> handler, Class<R> queryClass) {
        this.handlers.add(DEFAULT_DOMAIN, new RegisteredQueryHandler(resource, (ignored, message) -> handler.handle(message), queryClass));
        return this;
    }

    public <R> HandlerRegistry serveQuery(String resource, QueryHandlerDelegate<Void, R> handler, Class<R> queryClass) {
        this.handlers.add(DEFAULT_DOMAIN, new RegisteredQueryHandler<Void, R>(resource, handler, queryClass));
        return this;
    }

    public <R> HandlerRegistry serveCloudEventQuery(String resource, QueryHandler<R, CloudEvent> handler) {
        this.handlers.add(DEFAULT_DOMAIN, new RegisteredQueryHandler(resource, (ignored, message) -> handler.handle(message), CloudEvent.class));
        return this;
    }

    public HandlerRegistry serveCloudEventQuery(String resource, QueryHandlerDelegate<Void, CloudEvent> handler) {
        this.handlers.add(DEFAULT_DOMAIN, new RegisteredQueryHandler<Void, CloudEvent>(resource, handler, CloudEvent.class));
        return this;
    }

    @Deprecated(forRemoval=true)
    public <T> HandlerRegistry listenEvent(String eventName, DomainEventHandler<T> handler) {
        return this.listenEvent(eventName, handler, this.inferGenericParameterType(handler));
    }

    @Deprecated(forRemoval=true)
    public <T> HandlerRegistry handleDynamicEvents(String eventNamePattern, DomainEventHandler<T> handler) {
        return this.handleDynamicEvents(eventNamePattern, handler, this.inferGenericParameterType(handler));
    }

    @Deprecated(forRemoval=true)
    public <T> HandlerRegistry handleCommand(String commandName, DomainCommandHandler<T> handler) {
        this.commandHandlers.add(DEFAULT_DOMAIN, new RegisteredCommandHandler<T, T>(commandName, handler, this.inferGenericParameterType(handler)));
        return this;
    }

    @Deprecated(forRemoval=true)
    public <T, R> HandlerRegistry serveQuery(String resource, QueryHandler<T, R> handler) {
        return this.serveQuery(resource, handler, this.inferGenericParameterType(handler));
    }

    @Deprecated(forRemoval=true)
    private <T, R> Class<R> inferGenericParameterType(QueryHandler<T, R> handler) {
        try {
            ParameterizedType genericSuperclass = (ParameterizedType)handler.getClass().getGenericInterfaces()[0];
            return (Class)genericSuperclass.getActualTypeArguments()[1];
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to infer generic Query class, please use serveQuery(path, handler, class) instead");
        }
    }

    @Deprecated(forRemoval=true)
    private <T> Class<T> inferGenericParameterType(DomainCommandHandler<T> handler) {
        try {
            ParameterizedType genericSuperclass = (ParameterizedType)handler.getClass().getGenericInterfaces()[0];
            return (Class)genericSuperclass.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to infer generic Command class, please use handleCommand(path, handler, class) instead");
        }
    }

    @Deprecated(forRemoval=true)
    private <T> Class<T> inferGenericParameterType(DomainEventHandler<T> handler) {
        try {
            ParameterizedType genericSuperclass = (ParameterizedType)handler.getClass().getGenericInterfaces()[0];
            return (Class)genericSuperclass.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to infer generic Query class, please use listenEvent(eventName, handler, class) instead");
        }
    }

    @Generated
    public RegisteredDomainHandlers<RegisteredEventListener<?, ?>> getDomainEventListeners() {
        return this.domainEventListeners;
    }

    @Generated
    public RegisteredDomainHandlers<RegisteredEventListener<?, ?>> getDynamicEventHandlers() {
        return this.dynamicEventHandlers;
    }

    @Generated
    public RegisteredDomainHandlers<RegisteredEventListener<?, ?>> getEventNotificationListener() {
        return this.eventNotificationListener;
    }

    @Generated
    public RegisteredDomainHandlers<RegisteredQueryHandler<?, ?>> getHandlers() {
        return this.handlers;
    }

    @Generated
    public RegisteredDomainHandlers<RegisteredCommandHandler<?, ?>> getCommandHandlers() {
        return this.commandHandlers;
    }

    @Generated
    HandlerRegistry() {
    }
}

