/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit;

import io.micrometer.core.instrument.MeterRegistry;
import java.beans.ConstructorProperties;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.api.domain.DomainEventBus;
import org.reactivecommons.async.api.DirectAsyncGateway;
import org.reactivecommons.async.commons.DiscardNotifier;
import org.reactivecommons.async.commons.HandlerResolver;
import org.reactivecommons.async.commons.config.BrokerConfig;
import org.reactivecommons.async.commons.converters.MessageConverter;
import org.reactivecommons.async.commons.ext.CustomReporter;
import org.reactivecommons.async.commons.reply.ReactiveReplyRouter;
import org.reactivecommons.async.rabbit.RabbitDirectAsyncGateway;
import org.reactivecommons.async.rabbit.RabbitDomainEventBus;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageListener;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageSender;
import org.reactivecommons.async.rabbit.config.props.AsyncProps;
import org.reactivecommons.async.rabbit.converters.json.RabbitJacksonMessageConverter;
import org.reactivecommons.async.rabbit.health.RabbitReactiveHealthIndicator;
import org.reactivecommons.async.rabbit.listeners.ApplicationCommandListener;
import org.reactivecommons.async.rabbit.listeners.ApplicationEventListener;
import org.reactivecommons.async.rabbit.listeners.ApplicationNotificationListener;
import org.reactivecommons.async.rabbit.listeners.ApplicationQueryListener;
import org.reactivecommons.async.rabbit.listeners.ApplicationReplyListener;
import org.reactivecommons.async.starter.broker.BrokerProvider;
import org.reactivecommons.async.starter.config.health.RCHealth;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.ExchangeSpecification;

public class RabbitMQBrokerProvider
implements BrokerProvider<AsyncProps> {
    @Generated
    private static final Logger log = Logger.getLogger(RabbitMQBrokerProvider.class.getName());
    private final String domain;
    private final AsyncProps props;
    private final BrokerConfig config;
    private final ReactiveReplyRouter router;
    private final RabbitJacksonMessageConverter converter;
    private final MeterRegistry meterRegistry;
    private final CustomReporter errorReporter;
    private final RabbitReactiveHealthIndicator healthIndicator;
    private final ReactiveMessageListener receiver;
    private final ReactiveMessageSender sender;
    private final DiscardNotifier discardNotifier;

    public DomainEventBus getDomainBus() {
        String exchangeName = this.props.getBrokerConfigProps().getDomainEventsExchangeName();
        if (this.props.getCreateTopology().booleanValue()) {
            this.sender.getTopologyCreator().declare(ExchangeSpecification.exchange((String)exchangeName).durable(true).type("topic")).subscribe();
        }
        return new RabbitDomainEventBus(this.sender, exchangeName, this.config);
    }

    public DirectAsyncGateway getDirectAsyncGateway() {
        String exchangeName = this.props.getBrokerConfigProps().getDirectMessagesExchangeName();
        if (this.props.getCreateTopology().booleanValue()) {
            this.sender.getTopologyCreator().declare(ExchangeSpecification.exchange((String)exchangeName).durable(true).type("direct")).subscribe();
        }
        this.listenReplies();
        return new RabbitDirectAsyncGateway(this.config, this.router, this.sender, exchangeName, (MessageConverter)this.converter, this.meterRegistry);
    }

    public void listenDomainEvents(HandlerResolver resolver) {
        if (!this.props.getDomain().isIgnoreThisListener()) {
            ApplicationEventListener listener = new ApplicationEventListener(this.receiver, this.props.getBrokerConfigProps().getEventsQueue(), this.props.getBrokerConfigProps().getDomainEventsExchangeName(), resolver, (MessageConverter)this.converter, this.props.getWithDLQRetry().booleanValue(), this.props.getCreateTopology().booleanValue(), (long)this.props.getMaxRetries().intValue(), this.props.getRetryDelay().intValue(), this.props.getDomain().getEvents().getMaxLengthBytes(), this.discardNotifier, this.errorReporter, this.props.getAppName());
            listener.startListener();
        }
    }

    public void listenNotificationEvents(HandlerResolver resolver) {
        if (resolver.hasNotificationListeners()) {
            ApplicationNotificationListener listener = new ApplicationNotificationListener(this.receiver, this.props.getBrokerConfigProps().getDomainEventsExchangeName(), this.props.getBrokerConfigProps().getNotificationsQueue(), this.props.getCreateTopology().booleanValue(), resolver, (MessageConverter)this.converter, this.discardNotifier, this.errorReporter);
            listener.startListener();
        }
    }

    public void listenCommands(HandlerResolver resolver) {
        if (resolver.hasCommandHandlers()) {
            ApplicationCommandListener commandListener = new ApplicationCommandListener(this.receiver, this.props.getBrokerConfigProps().getCommandsQueue(), resolver, this.props.getDirect().getExchange(), (MessageConverter)this.converter, this.props.getWithDLQRetry().booleanValue(), this.props.getCreateTopology().booleanValue(), this.props.getDelayedCommands().booleanValue(), (long)this.props.getMaxRetries().intValue(), this.props.getRetryDelay().intValue(), this.props.getDirect().getMaxLengthBytes(), this.discardNotifier, this.errorReporter);
            commandListener.startListener();
        }
    }

    public void listenQueries(HandlerResolver resolver) {
        if (resolver.hasQueryHandlers()) {
            ApplicationQueryListener listener = new ApplicationQueryListener(this.receiver, this.props.getBrokerConfigProps().getQueriesQueue(), resolver, this.sender, this.props.getBrokerConfigProps().getDirectMessagesExchangeName(), (MessageConverter)this.converter, this.props.getBrokerConfigProps().getGlobalReplyExchangeName(), this.props.getWithDLQRetry().booleanValue(), this.props.getCreateTopology().booleanValue(), (long)this.props.getMaxRetries().intValue(), this.props.getRetryDelay().intValue(), this.props.getGlobal().getMaxLengthBytes(), this.props.getDirect().isDiscardTimeoutQueries(), this.discardNotifier, this.errorReporter);
            listener.startListener();
        }
    }

    public void listenReplies() {
        if (this.props.isListenReplies()) {
            ApplicationReplyListener replyListener = new ApplicationReplyListener(this.router, this.receiver, this.props.getBrokerConfigProps().getReplyQueue(), this.props.getBrokerConfigProps().getGlobalReplyExchangeName(), this.props.getCreateTopology().booleanValue());
            replyListener.startListening(this.config.getRoutingKey());
        }
    }

    public Mono<RCHealth> healthCheck() {
        return this.healthIndicator.health();
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public AsyncProps getProps() {
        return this.props;
    }

    @Generated
    public BrokerConfig getConfig() {
        return this.config;
    }

    @Generated
    public ReactiveReplyRouter getRouter() {
        return this.router;
    }

    @Generated
    public RabbitJacksonMessageConverter getConverter() {
        return this.converter;
    }

    @Generated
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    @Generated
    public CustomReporter getErrorReporter() {
        return this.errorReporter;
    }

    @Generated
    public RabbitReactiveHealthIndicator getHealthIndicator() {
        return this.healthIndicator;
    }

    @Generated
    public ReactiveMessageListener getReceiver() {
        return this.receiver;
    }

    @Generated
    public ReactiveMessageSender getSender() {
        return this.sender;
    }

    @Generated
    public DiscardNotifier getDiscardNotifier() {
        return this.discardNotifier;
    }

    @ConstructorProperties(value={"domain", "props", "config", "router", "converter", "meterRegistry", "errorReporter", "healthIndicator", "receiver", "sender", "discardNotifier"})
    @Generated
    public RabbitMQBrokerProvider(String domain, AsyncProps props, BrokerConfig config, ReactiveReplyRouter router, RabbitJacksonMessageConverter converter, MeterRegistry meterRegistry, CustomReporter errorReporter, RabbitReactiveHealthIndicator healthIndicator, ReactiveMessageListener receiver, ReactiveMessageSender sender, DiscardNotifier discardNotifier) {
        this.domain = domain;
        this.props = props;
        this.config = config;
        this.router = router;
        this.converter = converter;
        this.meterRegistry = meterRegistry;
        this.errorReporter = errorReporter;
        this.healthIndicator = healthIndicator;
        this.receiver = receiver;
        this.sender = sender;
        this.discardNotifier = discardNotifier;
    }
}

