/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit;

import io.micrometer.core.instrument.MeterRegistry;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.reactivecommons.async.commons.DiscardNotifier;
import org.reactivecommons.async.commons.config.BrokerConfig;
import org.reactivecommons.async.commons.converters.MessageConverter;
import org.reactivecommons.async.commons.ext.CustomReporter;
import org.reactivecommons.async.commons.reply.ReactiveReplyRouter;
import org.reactivecommons.async.rabbit.RabbitMQBrokerProvider;
import org.reactivecommons.async.rabbit.RabbitMQDiscardProvider;
import org.reactivecommons.async.rabbit.RabbitMQSetupUtils;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageListener;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageSender;
import org.reactivecommons.async.rabbit.config.ConnectionFactoryProvider;
import org.reactivecommons.async.rabbit.config.RabbitProperties;
import org.reactivecommons.async.rabbit.config.props.AsyncProps;
import org.reactivecommons.async.rabbit.converters.json.RabbitJacksonMessageConverter;
import org.reactivecommons.async.rabbit.health.RabbitReactiveHealthIndicator;
import org.reactivecommons.async.starter.broker.BrokerProvider;
import org.reactivecommons.async.starter.broker.BrokerProviderFactory;
import org.reactivecommons.async.starter.broker.DiscardProvider;
import org.springframework.stereotype.Service;

@Service(value="rabbitmq")
public class RabbitMQBrokerProviderFactory
implements BrokerProviderFactory<AsyncProps> {
    private final BrokerConfig config;
    private final ReactiveReplyRouter router;
    private final RabbitJacksonMessageConverter converter;
    private final MeterRegistry meterRegistry;
    private final CustomReporter errorReporter;

    public String getBrokerType() {
        return "rabbitmq";
    }

    public DiscardProvider getDiscardProvider(AsyncProps props) {
        return new RabbitMQDiscardProvider(props, this.config, (MessageConverter)this.converter);
    }

    public BrokerProvider<AsyncProps> getProvider(String domain, AsyncProps props, DiscardProvider discardProvider) {
        RabbitProperties properties = props.getConnectionProperties();
        ConnectionFactoryProvider provider = RabbitMQSetupUtils.connectionFactoryProvider(properties);
        RabbitReactiveHealthIndicator healthIndicator = new RabbitReactiveHealthIndicator(domain, provider.getConnectionFactory());
        ReactiveMessageSender sender = RabbitMQSetupUtils.createMessageSender(provider, props, (MessageConverter)this.converter);
        ReactiveMessageListener listener = RabbitMQSetupUtils.createMessageListener(provider, props);
        DiscardNotifier discardNotifier = props.isUseDiscardNotifierPerDomain() ? RabbitMQSetupUtils.createDiscardNotifier(sender, props, this.config, (MessageConverter)this.converter) : (DiscardNotifier)discardProvider.get();
        return new RabbitMQBrokerProvider(domain, props, this.config, this.router, this.converter, this.meterRegistry, this.errorReporter, healthIndicator, listener, sender, discardNotifier);
    }

    @ConstructorProperties(value={"config", "router", "converter", "meterRegistry", "errorReporter"})
    @Generated
    public RabbitMQBrokerProviderFactory(BrokerConfig config, ReactiveReplyRouter router, RabbitJacksonMessageConverter converter, MeterRegistry meterRegistry, CustomReporter errorReporter) {
        this.config = config;
        this.router = router;
        this.converter = converter;
        this.meterRegistry = meterRegistry;
        this.errorReporter = errorReporter;
    }
}

