/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.reactivecommons.async.commons.DiscardNotifier;
import org.reactivecommons.async.commons.config.BrokerConfig;
import org.reactivecommons.async.commons.converters.MessageConverter;
import org.reactivecommons.async.rabbit.RabbitMQSetupUtils;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageSender;
import org.reactivecommons.async.rabbit.config.ConnectionFactoryProvider;
import org.reactivecommons.async.rabbit.config.RabbitProperties;
import org.reactivecommons.async.rabbit.config.props.AsyncProps;
import org.reactivecommons.async.starter.broker.DiscardProvider;

public class RabbitMQDiscardProvider
implements DiscardProvider {
    private final AsyncProps props;
    private final BrokerConfig config;
    private final MessageConverter converter;
    private final Map<Boolean, DiscardNotifier> discardNotifier = new ConcurrentHashMap<Boolean, DiscardNotifier>();

    public DiscardNotifier get() {
        return this.discardNotifier.computeIfAbsent(true, this::buildDiscardNotifier);
    }

    private DiscardNotifier buildDiscardNotifier(boolean ignored) {
        RabbitProperties properties = this.props.getConnectionProperties();
        ConnectionFactoryProvider provider = RabbitMQSetupUtils.connectionFactoryProvider(properties);
        ReactiveMessageSender sender = RabbitMQSetupUtils.createMessageSender(provider, this.props, this.converter);
        return RabbitMQSetupUtils.createDiscardNotifier(sender, this.props, this.config, this.converter);
    }

    @ConstructorProperties(value={"props", "config", "converter"})
    @Generated
    public RabbitMQDiscardProvider(AsyncProps props, BrokerConfig config, MessageConverter converter) {
        this.props = props;
        this.config = config;
        this.converter = converter;
    }
}

