/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.reactivecommons.api.domain.DomainEventBus;
import org.reactivecommons.async.commons.DLQDiscardNotifier;
import org.reactivecommons.async.commons.DiscardNotifier;
import org.reactivecommons.async.commons.config.BrokerConfig;
import org.reactivecommons.async.commons.converters.MessageConverter;
import org.reactivecommons.async.rabbit.RabbitDomainEventBus;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageListener;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageSender;
import org.reactivecommons.async.rabbit.communications.TopologyCreator;
import org.reactivecommons.async.rabbit.config.ConnectionFactoryProvider;
import org.reactivecommons.async.rabbit.config.RabbitProperties;
import org.reactivecommons.async.rabbit.config.props.AsyncProps;
import org.reactivecommons.async.rabbit.config.spring.RabbitPropertiesBase;
import org.springframework.boot.context.properties.PropertyMapper;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.ChannelPool;
import reactor.rabbitmq.ChannelPoolFactory;
import reactor.rabbitmq.ChannelPoolOptions;
import reactor.rabbitmq.RabbitFlux;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.ReceiverOptions;
import reactor.rabbitmq.Sender;
import reactor.rabbitmq.SenderOptions;
import reactor.rabbitmq.Utils;
import reactor.util.retry.Retry;

public final class RabbitMQSetupUtils {
    @Generated
    private static final Logger log = Logger.getLogger(RabbitMQSetupUtils.class.getName());
    private static final String LISTENER_TYPE = "listener";
    private static final String SENDER_TYPE = "sender";
    private static final String DEFAULT_PROTOCOL;
    public static final int START_INTERVAL = 300;
    public static final int MAX_BACKOFF_INTERVAL = 3000;

    public static ConnectionFactoryProvider connectionFactoryProvider(RabbitProperties properties) {
        ConnectionFactory factory = new ConnectionFactory();
        PropertyMapper map = PropertyMapper.get();
        map.from(properties::determineHost).whenNonNull().to(arg_0 -> ((ConnectionFactory)factory).setHost(arg_0));
        map.from(properties::determinePort).to(arg_0 -> ((ConnectionFactory)factory).setPort(arg_0));
        map.from(properties::determineUsername).whenNonNull().to(arg_0 -> ((ConnectionFactory)factory).setUsername(arg_0));
        map.from(properties::determinePassword).whenNonNull().to(arg_0 -> ((ConnectionFactory)factory).setPassword(arg_0));
        map.from(properties::determineVirtualHost).whenNonNull().to(arg_0 -> ((ConnectionFactory)factory).setVirtualHost(arg_0));
        factory.useNio();
        RabbitMQSetupUtils.setUpSSL(factory, properties);
        return () -> factory;
    }

    public static ReactiveMessageSender createMessageSender(ConnectionFactoryProvider provider, AsyncProps props, MessageConverter converter) {
        Sender sender = RabbitFlux.createSender((SenderOptions)RabbitMQSetupUtils.reactiveCommonsSenderOptions(props.getAppName(), provider, props.getConnectionProperties()));
        return new ReactiveMessageSender(sender, props.getAppName(), converter, new TopologyCreator(sender));
    }

    public static ReactiveMessageListener createMessageListener(ConnectionFactoryProvider provider, AsyncProps props) {
        Mono<Connection> connection = RabbitMQSetupUtils.createConnectionMono(provider.getConnectionFactory(), props.getAppName(), LISTENER_TYPE);
        Receiver receiver = RabbitFlux.createReceiver((ReceiverOptions)new ReceiverOptions().connectionMono(connection));
        Sender sender = RabbitFlux.createSender((SenderOptions)new SenderOptions().connectionMono(connection));
        return new ReactiveMessageListener(receiver, new TopologyCreator(sender), props.getFlux().getMaxConcurrency(), props.getPrefetchCount());
    }

    public static TopologyCreator createTopologyCreator(AsyncProps props) {
        ConnectionFactoryProvider provider = RabbitMQSetupUtils.connectionFactoryProvider(props.getConnectionProperties());
        Mono<Connection> connection = RabbitMQSetupUtils.createConnectionMono(provider.getConnectionFactory(), props.getAppName(), LISTENER_TYPE);
        Sender sender = RabbitFlux.createSender((SenderOptions)new SenderOptions().connectionMono(connection));
        return new TopologyCreator(sender);
    }

    public static DiscardNotifier createDiscardNotifier(ReactiveMessageSender sender, AsyncProps props, BrokerConfig brokerConfig, MessageConverter converter) {
        RabbitDomainEventBus appDomainEventBus = new RabbitDomainEventBus(sender, props.getBrokerConfigProps().getDomainEventsExchangeName(), brokerConfig);
        return new DLQDiscardNotifier((DomainEventBus)appDomainEventBus, converter);
    }

    private static SenderOptions reactiveCommonsSenderOptions(String appName, ConnectionFactoryProvider provider, RabbitProperties rabbitProperties) {
        Mono<Connection> senderConnection = RabbitMQSetupUtils.createConnectionMono(provider.getConnectionFactory(), appName, SENDER_TYPE);
        ChannelPoolOptions channelPoolOptions = new ChannelPoolOptions();
        PropertyMapper map = PropertyMapper.get();
        map.from(rabbitProperties.getCache().getChannel()::getSize).whenNonNull().to(arg_0 -> ((ChannelPoolOptions)channelPoolOptions).maxCacheSize(arg_0));
        ChannelPool channelPool = ChannelPoolFactory.createChannelPool(senderConnection, (ChannelPoolOptions)channelPoolOptions);
        return new SenderOptions().channelPool(channelPool).resourceManagementChannelMono(channelPool.getChannelMono().transform(Utils::cache));
    }

    private static Mono<Connection> createConnectionMono(ConnectionFactory factory, String connectionPrefix, String connectionType) {
        return Mono.fromCallable(() -> factory.newConnection(connectionPrefix + " " + connectionType)).doOnError(err -> log.log(Level.SEVERE, "Error creating connection to RabbitMQ Broker in host '" + factory.getHost() + "'. Starting retry process...", (Throwable)err)).retryWhen((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofMillis(300L)).maxBackoff(Duration.ofMillis(3000L))).cache();
    }

    private static void setUpSSL(ConnectionFactory factory, RabbitProperties properties) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        RabbitPropertiesBase.Ssl ssl = properties.getSsl();
        if (ssl != null && ssl.isEnabled()) {
            Object[] keyManagers = RabbitMQSetupUtils.configureKeyManagers(ssl);
            Object[] trustManagers = RabbitMQSetupUtils.configureTrustManagers(ssl);
            SecureRandom secureRandom = SecureRandom.getInstanceStrong();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Initializing SSLContext with KM: " + Arrays.toString(keyManagers) + ", TM: " + Arrays.toString(trustManagers) + ", random: " + String.valueOf(secureRandom));
            }
            SSLContext context = RabbitMQSetupUtils.createSSLContext(ssl);
            context.init((KeyManager[])keyManagers, (TrustManager[])trustManagers, secureRandom);
            factory.useSslProtocol(context);
            RabbitMQSetupUtils.logDetails((TrustManager[])trustManagers);
            if (ssl.isVerifyHostname()) {
                factory.enableHostnameVerification();
            }
        }
    }

    private static KeyManager[] configureKeyManagers(RabbitPropertiesBase.Ssl ssl) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyManager[] keyManagers = null;
        if (ssl.getKeyStore() != null) {
            KeyStore ks = KeyStore.getInstance(ssl.getKeyStoreType());
            char[] keyPassphrase = null;
            if (ssl.getKeyStorePassword() != null) {
                keyPassphrase = ssl.getKeyStorePassword().toCharArray();
            }
            try (FileInputStream inputStream = new FileInputStream(ssl.getKeyStore());){
                ks.load(inputStream, keyPassphrase);
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyPassphrase);
            keyManagers = kmf.getKeyManagers();
        }
        return keyManagers;
    }

    private static TrustManager[] configureTrustManagers(RabbitPropertiesBase.Ssl ssl) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore tks = null;
        if (ssl.getTrustStore() != null) {
            tks = KeyStore.getInstance(ssl.getTrustStoreType());
            char[] trustPassphrase = null;
            if (ssl.getTrustStorePassword() != null) {
                trustPassphrase = ssl.getTrustStorePassword().toCharArray();
            }
            try (FileInputStream inputStream = new FileInputStream(ssl.getTrustStore());){
                tks.load(inputStream, trustPassphrase);
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(tks);
        return tmf.getTrustManagers();
    }

    private static SSLContext createSSLContext(RabbitPropertiesBase.Ssl ssl) throws NoSuchAlgorithmException {
        return SSLContext.getInstance(ssl.getAlgorithm() != null ? ssl.getAlgorithm() : DEFAULT_PROTOCOL);
    }

    private static void logDetails(TrustManager[] managers) {
        boolean found = false;
        for (TrustManager trustManager : managers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            found = true;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            log.info("Loaded " + x509TrustManager.getAcceptedIssuers().length + " accepted issuers for rabbitmq");
        }
        if (!found) {
            log.warning("No X509TrustManager found in the truststore.");
        }
    }

    @Generated
    private RabbitMQSetupUtils() {
    }

    static {
        String protocol = "TLSv1.1";
        try {
            String[] protocols;
            for (String prot : protocols = SSLContext.getDefault().getSupportedSSLParameters().getProtocols()) {
                if (!"TLSv1.2".equals(prot)) continue;
                protocol = "TLSv1.2";
                break;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        DEFAULT_PROTOCOL = protocol;
    }
}

