/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit.config.spring;

import java.lang.invoke.CallSite;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RabbitPropertiesBase {
    private String host = "localhost";
    private int port = 5672;
    private String username = "guest";
    private String password = "guest";
    private final Ssl ssl = new Ssl();
    private String virtualHost;
    private String addresses;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration requestedHeartbeat;
    private boolean publisherConfirms;
    private boolean publisherReturns;
    private Duration connectionTimeout;
    private final Cache cache = new Cache();
    private final Listener listener = new Listener();
    private final Template template = new Template();
    private List<Address> parsedAddresses;

    public String determineHost() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.getHost();
        }
        return this.parsedAddresses.get((int)0).host;
    }

    public int determinePort() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.getPort();
        }
        Address address = this.parsedAddresses.get(0);
        return address.port;
    }

    public String determineAddresses() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.host + ":" + this.port;
        }
        ArrayList<CallSite> addressStrings = new ArrayList<CallSite>();
        for (Address parsedAddress : this.parsedAddresses) {
            addressStrings.add((CallSite)((Object)(parsedAddress.host + ":" + parsedAddress.port)));
        }
        return StringUtils.collectionToCommaDelimitedString(addressStrings);
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
        this.parsedAddresses = this.parseAddresses(addresses);
    }

    private List<Address> parseAddresses(String addresses) {
        ArrayList<Address> parsedAddressesLocal = new ArrayList<Address>();
        for (String address : StringUtils.commaDelimitedListToStringArray((String)addresses)) {
            parsedAddressesLocal.add(new Address(address));
        }
        return parsedAddressesLocal;
    }

    public String determineUsername() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.username;
        }
        Address address = this.parsedAddresses.get(0);
        return address.username != null ? address.username : this.username;
    }

    public String determinePassword() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.getPassword();
        }
        Address address = this.parsedAddresses.get(0);
        return address.password != null ? address.password : this.getPassword();
    }

    public String determineVirtualHost() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.getVirtualHost();
        }
        Address address = this.parsedAddresses.get(0);
        return address.virtualHost != null ? address.virtualHost : this.getVirtualHost();
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = "".equals(virtualHost) ? "/" : virtualHost;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Ssl getSsl() {
        return this.ssl;
    }

    @Generated
    public String getVirtualHost() {
        return this.virtualHost;
    }

    @Generated
    public String getAddresses() {
        return this.addresses;
    }

    @Generated
    public Duration getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    @Generated
    public void setRequestedHeartbeat(Duration requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    @Generated
    public void setPublisherConfirms(boolean publisherConfirms) {
        this.publisherConfirms = publisherConfirms;
    }

    @Generated
    public boolean isPublisherConfirms() {
        return this.publisherConfirms;
    }

    @Generated
    public void setPublisherReturns(boolean publisherReturns) {
        this.publisherReturns = publisherReturns;
    }

    @Generated
    public boolean isPublisherReturns() {
        return this.publisherReturns;
    }

    @Generated
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public Cache getCache() {
        return this.cache;
    }

    @Generated
    public Listener getListener() {
        return this.listener;
    }

    @Generated
    public Template getTemplate() {
        return this.template;
    }

    public static class Ssl {
        private boolean enabled;
        private String keyStore;
        private String keyStoreType = "PKCS12";
        private String keyStorePassword;
        private String trustStore;
        private String trustStoreType = "JKS";
        private String trustStorePassword;
        private String algorithm;
        private boolean validateServerCertificate = true;
        private boolean verifyHostname = true;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getKeyStore() {
            return this.keyStore;
        }

        @Generated
        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        @Generated
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        @Generated
        public String getTrustStore() {
            return this.trustStore;
        }

        @Generated
        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        @Generated
        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        @Generated
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Generated
        public boolean isValidateServerCertificate() {
            return this.validateServerCertificate;
        }

        @Generated
        public boolean isVerifyHostname() {
            return this.verifyHostname;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        @Generated
        public void setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        @Generated
        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Generated
        public void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        @Generated
        public void setTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
        }

        @Generated
        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        @Generated
        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Generated
        public void setValidateServerCertificate(boolean validateServerCertificate) {
            this.validateServerCertificate = validateServerCertificate;
        }

        @Generated
        public void setVerifyHostname(boolean verifyHostname) {
            this.verifyHostname = verifyHostname;
        }
    }

    public static class Cache {
        private final Channel channel = new Channel();
        private final Connection connection = new Connection();

        @Generated
        public Channel getChannel() {
            return this.channel;
        }

        @Generated
        public Connection getConnection() {
            return this.connection;
        }

        public static class Channel {
            private Integer size;
            private Duration checkoutTimeout;

            @Generated
            public Integer getSize() {
                return this.size;
            }

            @Generated
            public Duration getCheckoutTimeout() {
                return this.checkoutTimeout;
            }

            @Generated
            public void setSize(Integer size) {
                this.size = size;
            }

            @Generated
            public void setCheckoutTimeout(Duration checkoutTimeout) {
                this.checkoutTimeout = checkoutTimeout;
            }
        }

        public static class Connection {
            private String mode = "CHANNEL";
            private Integer size;

            @Generated
            public String getMode() {
                return this.mode;
            }

            @Generated
            public Integer getSize() {
                return this.size;
            }

            @Generated
            public void setMode(String mode) {
                this.mode = mode;
            }

            @Generated
            public void setSize(Integer size) {
                this.size = size;
            }
        }
    }

    public static class Listener {
        private ContainerType type = ContainerType.SIMPLE;
        private final SimpleContainer simple = new SimpleContainer();
        private final DirectContainer direct = new DirectContainer();

        @Generated
        public ContainerType getType() {
            return this.type;
        }

        @Generated
        public SimpleContainer getSimple() {
            return this.simple;
        }

        @Generated
        public DirectContainer getDirect() {
            return this.direct;
        }

        @Generated
        public void setType(ContainerType type) {
            this.type = type;
        }
    }

    public static class Template {
        private final Retry retry = new Retry();
        private Boolean mandatory;
        private Duration receiveTimeout;
        private Duration replyTimeout;
        private String exchange = "";
        private String routingKey = "";
        private String queue;

        @Generated
        public Retry getRetry() {
            return this.retry;
        }

        @Generated
        public Boolean getMandatory() {
            return this.mandatory;
        }

        @Generated
        public Duration getReceiveTimeout() {
            return this.receiveTimeout;
        }

        @Generated
        public Duration getReplyTimeout() {
            return this.replyTimeout;
        }

        @Generated
        public String getExchange() {
            return this.exchange;
        }

        @Generated
        public String getRoutingKey() {
            return this.routingKey;
        }

        @Generated
        public String getQueue() {
            return this.queue;
        }

        @Generated
        public void setMandatory(Boolean mandatory) {
            this.mandatory = mandatory;
        }

        @Generated
        public void setReceiveTimeout(Duration receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        @Generated
        public void setReplyTimeout(Duration replyTimeout) {
            this.replyTimeout = replyTimeout;
        }

        @Generated
        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        @Generated
        public void setRoutingKey(String routingKey) {
            this.routingKey = routingKey;
        }

        @Generated
        public void setQueue(String queue) {
            this.queue = queue;
        }
    }

    private static final class Address {
        private static final String PREFIX_AMQP = "amqp://";
        private static final int DEFAULT_PORT = 5672;
        private String host;
        private int port;
        private String username;
        private String password;
        private String virtualHost;

        private Address(String input) {
            input = input.trim();
            input = this.trimPrefix(input);
            input = this.parseUsernameAndPassword(input);
            input = this.parseVirtualHost(input);
            this.parseHostAndPort(input);
        }

        private String trimPrefix(String input) {
            if (input.startsWith(PREFIX_AMQP)) {
                input = input.substring(PREFIX_AMQP.length());
            }
            return input;
        }

        private String parseUsernameAndPassword(String input) {
            if (input.contains("@")) {
                String[] split = StringUtils.split((String)input, (String)"@");
                if (split == null) {
                    return input;
                }
                String creds = split[0];
                input = split[1];
                split = StringUtils.split((String)creds, (String)":");
                if (split != null) {
                    this.username = split[0];
                    if (split.length > 1) {
                        this.password = split[1];
                    }
                }
            }
            return input;
        }

        private String parseVirtualHost(String input) {
            int hostIndex = input.indexOf(47);
            if (hostIndex >= 0) {
                this.virtualHost = input.substring(hostIndex + 1);
                if (this.virtualHost.isEmpty()) {
                    this.virtualHost = "/";
                }
                input = input.substring(0, hostIndex);
            }
            return input;
        }

        private void parseHostAndPort(String input) {
            int portIndex = input.indexOf(58);
            if (portIndex == -1) {
                this.host = input;
                this.port = 5672;
            } else {
                this.host = input.substring(0, portIndex);
                this.port = Integer.parseInt(input.substring(portIndex + 1));
            }
        }
    }

    public static class ListenerRetry
    extends Retry {
        private boolean stateless = true;

        @Generated
        public boolean isStateless() {
            return this.stateless;
        }

        @Generated
        public void setStateless(boolean stateless) {
            this.stateless = stateless;
        }
    }

    public static class Retry {
        private boolean enabled;
        private int maxAttempts = 3;
        private Duration initialInterval = Duration.ofMillis(1000L);
        private double multiplier = 1.0;
        private Duration maxInterval = Duration.ofMillis(10000L);

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        @Generated
        public Duration getInitialInterval() {
            return this.initialInterval;
        }

        @Generated
        public double getMultiplier() {
            return this.multiplier;
        }

        @Generated
        public Duration getMaxInterval() {
            return this.maxInterval;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Generated
        public void setInitialInterval(Duration initialInterval) {
            this.initialInterval = initialInterval;
        }

        @Generated
        public void setMultiplier(double multiplier) {
            this.multiplier = multiplier;
        }

        @Generated
        public void setMaxInterval(Duration maxInterval) {
            this.maxInterval = maxInterval;
        }
    }

    public static class DirectContainer
    extends AmqpContainer {
        private Integer consumersPerQueue;
        private boolean missingQueuesFatal = false;

        @Generated
        public Integer getConsumersPerQueue() {
            return this.consumersPerQueue;
        }

        @Override
        @Generated
        public boolean isMissingQueuesFatal() {
            return this.missingQueuesFatal;
        }

        @Generated
        public void setConsumersPerQueue(Integer consumersPerQueue) {
            this.consumersPerQueue = consumersPerQueue;
        }

        @Generated
        public void setMissingQueuesFatal(boolean missingQueuesFatal) {
            this.missingQueuesFatal = missingQueuesFatal;
        }
    }

    public static class SimpleContainer
    extends AmqpContainer {
        private Integer concurrency;
        private Integer maxConcurrency;
        private Integer transactionSize;
        private boolean missingQueuesFatal = true;

        @Generated
        public Integer getConcurrency() {
            return this.concurrency;
        }

        @Generated
        public Integer getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Generated
        public Integer getTransactionSize() {
            return this.transactionSize;
        }

        @Override
        @Generated
        public boolean isMissingQueuesFatal() {
            return this.missingQueuesFatal;
        }

        @Generated
        public void setConcurrency(Integer concurrency) {
            this.concurrency = concurrency;
        }

        @Generated
        public void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Generated
        public void setTransactionSize(Integer transactionSize) {
            this.transactionSize = transactionSize;
        }

        @Generated
        public void setMissingQueuesFatal(boolean missingQueuesFatal) {
            this.missingQueuesFatal = missingQueuesFatal;
        }
    }

    public static abstract class AmqpContainer {
        private boolean autoStartup = true;
        private Integer acknowledgeMode;
        private Integer prefetch;
        private Boolean defaultRequeueRejected;
        private Duration idleEventInterval;
        private final ListenerRetry retry = new ListenerRetry();

        public abstract boolean isMissingQueuesFatal();

        @Generated
        public boolean isAutoStartup() {
            return this.autoStartup;
        }

        @Generated
        public Integer getAcknowledgeMode() {
            return this.acknowledgeMode;
        }

        @Generated
        public Integer getPrefetch() {
            return this.prefetch;
        }

        @Generated
        public Boolean getDefaultRequeueRejected() {
            return this.defaultRequeueRejected;
        }

        @Generated
        public Duration getIdleEventInterval() {
            return this.idleEventInterval;
        }

        @Generated
        public ListenerRetry getRetry() {
            return this.retry;
        }

        @Generated
        public void setAutoStartup(boolean autoStartup) {
            this.autoStartup = autoStartup;
        }

        @Generated
        public void setAcknowledgeMode(Integer acknowledgeMode) {
            this.acknowledgeMode = acknowledgeMode;
        }

        @Generated
        public void setPrefetch(Integer prefetch) {
            this.prefetch = prefetch;
        }

        @Generated
        public void setDefaultRequeueRejected(Boolean defaultRequeueRejected) {
            this.defaultRequeueRejected = defaultRequeueRejected;
        }

        @Generated
        public void setIdleEventInterval(Duration idleEventInterval) {
            this.idleEventInterval = idleEventInterval;
        }
    }

    public static enum ContainerType {
        SIMPLE,
        DIRECT;

    }
}

