/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit.health;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.net.SocketException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivecommons.async.rabbit.health.RabbitMQHealthException;
import org.reactivecommons.async.starter.config.health.RCHealth;
import org.reactivecommons.async.starter.config.health.RCHealthIndicator;
import reactor.core.publisher.Mono;

public class RabbitReactiveHealthIndicator
extends RCHealthIndicator {
    @Generated
    private static final Logger log = LogManager.getLogger(RabbitReactiveHealthIndicator.class);
    private final String domain;
    private final ConnectionFactory connectionFactory;

    public RabbitReactiveHealthIndicator(String domain, ConnectionFactory connectionFactory) {
        this.domain = domain;
        this.connectionFactory = connectionFactory.clone();
        this.connectionFactory.useBlockingIo();
    }

    public Mono<RCHealth> doHealthCheck(RCHealth.RCHealthBuilder builder) {
        builder.withDetail("domain", (Object)this.domain);
        return Mono.fromCallable(() -> this.getRawVersion(this.connectionFactory)).map(status -> builder.up().withDetail("version", status).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRawVersion(ConnectionFactory factory) {
        Connection connection = null;
        try {
            connection = factory.newConnection();
            String string = connection.getServerProperties().get("version").toString();
            return string;
        }
        catch (SocketException e) {
            log.warn("Identified error", (Throwable)e);
            throw new RabbitMQHealthException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    log.error("Error closing health connection", (Throwable)e);
                }
            }
        }
    }
}

