/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.starter.impl.common.rabbit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.async.commons.converters.json.ObjectMapperSupplier;
import org.reactivecommons.async.rabbit.RabbitMQBrokerProviderFactory;
import org.reactivecommons.async.rabbit.config.RabbitProperties;
import org.reactivecommons.async.rabbit.config.RabbitPropertiesAutoConfig;
import org.reactivecommons.async.rabbit.config.props.AsyncPropsDomain;
import org.reactivecommons.async.rabbit.config.props.AsyncRabbitPropsDomainProperties;
import org.reactivecommons.async.rabbit.converters.json.RabbitJacksonMessageConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={RabbitPropertiesAutoConfig.class, AsyncRabbitPropsDomainProperties.class})
@Import(value={AsyncPropsDomain.class, RabbitMQBrokerProviderFactory.class})
public class RabbitMQConfig {
    @Generated
    private static final Logger log = Logger.getLogger(RabbitMQConfig.class.getName());

    @Bean
    @ConditionalOnMissingBean(value={RabbitJacksonMessageConverter.class})
    public RabbitJacksonMessageConverter messageConverter(ObjectMapperSupplier objectMapperSupplier) {
        return new RabbitJacksonMessageConverter((ObjectMapper)objectMapperSupplier.get());
    }

    @Bean
    @ConditionalOnMissingBean(value={AsyncPropsDomain.RabbitSecretFiller.class})
    public AsyncPropsDomain.RabbitSecretFiller defaultRabbitSecretFiller() {
        return (ignoredDomain, ignoredProps) -> {};
    }

    @Bean
    @ConditionalOnMissingBean(value={RabbitProperties.class})
    public RabbitProperties defaultRabbitProperties(RabbitPropertiesAutoConfig properties, ObjectMapperSupplier supplier) {
        return (RabbitProperties)((ObjectMapper)supplier.get()).convertValue((Object)properties, RabbitProperties.class);
    }

    @Generated
    public RabbitMQConfig() {
    }
}

