/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.starter.config;

import java.util.Map;
import java.util.TreeMap;
import org.reactivecommons.async.commons.HandlerResolver;
import org.reactivecommons.async.starter.exceptions.InvalidConfigurationException;

public class DomainHandlers {
    private final Map<String, HandlerResolver> handlers = new TreeMap<String, HandlerResolver>();

    public void add(String domain, HandlerResolver resolver) {
        this.handlers.put(domain, resolver);
    }

    public HandlerResolver get(String domain) {
        HandlerResolver handlerResolver = this.handlers.get(domain);
        if (handlerResolver == null) {
            throw new InvalidConfigurationException("You are trying to use the domain " + domain + " but this connection is not defined");
        }
        return handlerResolver;
    }
}

