/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.starter.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Map;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.async.commons.config.BrokerConfig;
import org.reactivecommons.async.commons.converters.json.DefaultObjectMapperSupplier;
import org.reactivecommons.async.commons.converters.json.ObjectMapperSupplier;
import org.reactivecommons.async.commons.ext.CustomReporter;
import org.reactivecommons.async.commons.ext.DefaultCustomReporter;
import org.reactivecommons.async.commons.reply.ReactiveReplyRouter;
import org.reactivecommons.async.starter.broker.BrokerProvider;
import org.reactivecommons.async.starter.broker.BrokerProviderFactory;
import org.reactivecommons.async.starter.broker.DiscardProvider;
import org.reactivecommons.async.starter.config.ConnectionManager;
import org.reactivecommons.async.starter.config.health.ReactiveCommonsHealthConfig;
import org.reactivecommons.async.starter.props.GenericAsyncProps;
import org.reactivecommons.async.starter.props.GenericAsyncPropsDomain;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ReactiveCommonsHealthConfig.class})
@ComponentScan(value={"org.reactivecommons.async.starter.impl.common"})
public class ReactiveCommonsConfig {
    @Generated
    private static final Logger log = Logger.getLogger(ReactiveCommonsConfig.class.getName());

    @Bean
    public ConnectionManager buildConnectionManager(ApplicationContext context) {
        Map props = context.getBeansOfType(GenericAsyncPropsDomain.class);
        Map providers = context.getBeansOfType(BrokerProviderFactory.class);
        ConnectionManager connectionManager = new ConnectionManager();
        props.forEach((beanName, domainProps) -> {
            Object defaultDomainProps = domainProps.getProps("app");
            domainProps.forEach((domain, asyncPropsObject) -> {
                String domainName = (String)domain;
                GenericAsyncProps asyncProps = (GenericAsyncProps)asyncPropsObject;
                if (asyncProps.isEnabled()) {
                    BrokerProviderFactory factory = (BrokerProviderFactory)providers.get(asyncProps.getBrokerType());
                    if (!defaultDomainProps.isEnabled()) {
                        asyncProps.setUseDiscardNotifierPerDomain(true);
                    }
                    DiscardProvider discardProvider = factory.getDiscardProvider(defaultDomainProps);
                    BrokerProvider<GenericAsyncProps> provider = factory.getProvider(domainName, asyncProps, discardProvider);
                    connectionManager.addDomain(domainName, provider);
                }
            });
        });
        return connectionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public BrokerConfig brokerConfig() {
        return new BrokerConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapperSupplier objectMapperSupplier() {
        return new DefaultObjectMapperSupplier();
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper defaultReactiveCommonsObjectMapper(ObjectMapperSupplier supplier) {
        return (ObjectMapper)supplier.get();
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveReplyRouter.class})
    public ReactiveReplyRouter defaultReactiveReplyRouter() {
        return new ReactiveReplyRouter();
    }

    @Bean
    @ConditionalOnMissingBean(value={MeterRegistry.class})
    public MeterRegistry defaultRabbitMeterRegistry() {
        return new SimpleMeterRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    public CustomReporter reactiveCommonsCustomErrorReporter() {
        return new DefaultCustomReporter();
    }

    @Generated
    public ReactiveCommonsConfig() {
    }
}

