/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.starter.config;

import java.util.Map;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.async.api.DefaultCommandHandler;
import org.reactivecommons.async.api.DefaultQueryHandler;
import org.reactivecommons.async.api.HandlerRegistry;
import org.reactivecommons.async.commons.HandlerResolver;
import org.reactivecommons.async.commons.utils.resolver.HandlerResolverBuilder;
import org.reactivecommons.async.starter.config.DomainHandlers;
import org.reactivecommons.async.starter.props.GenericAsyncPropsDomain;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Mono;

@Configuration
@ComponentScan(value={"org.reactivecommons.async.starter.impl.listener"})
public class ReactiveCommonsListenersConfig {
    @Generated
    private static final Logger log = Logger.getLogger(ReactiveCommonsListenersConfig.class.getName());

    @Bean
    public DomainHandlers buildHandlers(ApplicationContext context, HandlerRegistry primaryRegistry, DefaultCommandHandler<?> commandHandler) {
        DomainHandlers handlers = new DomainHandlers();
        Map registries = context.getBeansOfType(HandlerRegistry.class);
        if (!registries.containsValue(primaryRegistry)) {
            registries.put("primaryHandlerRegistry", primaryRegistry);
        }
        Map props = context.getBeansOfType(GenericAsyncPropsDomain.class);
        props.forEach((beanName, properties) -> properties.forEach((domain, asyncProps) -> {
            String domainName = (String)domain;
            HandlerResolver resolver = HandlerResolverBuilder.buildResolver((String)domainName, (Map)registries, (DefaultCommandHandler)commandHandler);
            handlers.add(domainName, resolver);
        }));
        return handlers;
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultQueryHandler defaultHandler() {
        return command -> Mono.error((Throwable)new RuntimeException("No Handler Registered"));
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultCommandHandler defaultCommandHandler() {
        return message -> Mono.error((Throwable)new RuntimeException("No Handler Registered"));
    }

    @Bean
    @ConditionalOnMissingBean
    public HandlerRegistry defaultHandlerRegistry() {
        return HandlerRegistry.register();
    }

    @Generated
    public ReactiveCommonsListenersConfig() {
    }
}

