/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.starter.config.health;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivecommons.async.starter.broker.BrokerProvider;
import org.reactivecommons.async.starter.config.ConnectionManager;
import org.reactivecommons.async.starter.config.health.RCHealth;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveCommonsHealthIndicator
extends AbstractReactiveHealthIndicator {
    @Generated
    private static final Logger log = LogManager.getLogger(ReactiveCommonsHealthIndicator.class);
    public static final String DOMAIN = "domain";
    public static final String VERSION = "version";
    private final ConnectionManager manager;

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return Flux.fromIterable(this.manager.getProviders().values()).flatMap(BrokerProvider::healthCheck).reduceWith(Health::up, (health, status) -> this.reduceHealth((Health.Builder)health, (RCHealth)status)).map(b -> ((Health.Builder)b).build());
    }

    private Health.Builder reduceHealth(Health.Builder builder, RCHealth status) {
        String domain = status.getDetails().get(DOMAIN).toString();
        if (status.getStatus().equals((Object)RCHealth.Status.DOWN)) {
            log.error("Broker of domain {} is down", (Object)domain);
            return builder.down().withDetail(domain, status.getDetails());
        }
        return builder.withDetail(domain, status.getDetails());
    }

    @ConstructorProperties(value={"manager"})
    @Generated
    public ReactiveCommonsHealthIndicator(ConnectionManager manager) {
        this.manager = manager;
    }
}

