/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.starter.senders;

import io.cloudevents.CloudEvent;
import java.beans.ConstructorProperties;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.reactivecommons.api.domain.DomainEvent;
import org.reactivecommons.api.domain.DomainEventBus;
import org.reactivecommons.api.domain.RawMessage;
import org.reactivecommons.async.starter.exceptions.InvalidConfigurationException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class GenericDomainEventBus
implements DomainEventBus {
    private static final String DOMAIN_NOT_FOUND = "Domain not found: ";
    private final ConcurrentMap<String, DomainEventBus> domainEventBuses;

    public <T> Publisher<Void> emit(DomainEvent<T> event) {
        return this.emit("app", event);
    }

    public <T> Publisher<Void> emit(String domain, DomainEvent<T> event) {
        DomainEventBus domainEventBus = (DomainEventBus)this.domainEventBuses.get(domain);
        if (domainEventBus == null) {
            return Mono.error(() -> new InvalidConfigurationException(DOMAIN_NOT_FOUND + domain));
        }
        return domainEventBus.emit(event);
    }

    public Publisher<Void> emit(CloudEvent event) {
        return this.emit("app", event);
    }

    public Publisher<Void> emit(String domain, CloudEvent event) {
        DomainEventBus domainEventBus = (DomainEventBus)this.domainEventBuses.get(domain);
        if (domainEventBus == null) {
            return Mono.error(() -> new InvalidConfigurationException(DOMAIN_NOT_FOUND + domain));
        }
        return domainEventBus.emit(event);
    }

    public Publisher<Void> emit(RawMessage event) {
        return this.emit("app", event);
    }

    public Publisher<Void> emit(String domain, RawMessage event) {
        DomainEventBus domainEventBus = (DomainEventBus)this.domainEventBuses.get(domain);
        if (domainEventBus == null) {
            return Mono.error(() -> new InvalidConfigurationException(DOMAIN_NOT_FOUND + domain));
        }
        return domainEventBus.emit(event);
    }

    @ConstructorProperties(value={"domainEventBuses"})
    @Generated
    public GenericDomainEventBus(ConcurrentMap<String, DomainEventBus> domainEventBuses) {
        this.domainEventBuses = domainEventBuses;
    }
}

