/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.commons;

import com.fasterxml.jackson.databind.JsonNode;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.beans.ConstructorProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.api.domain.DomainEvent;
import org.reactivecommons.api.domain.DomainEventBus;
import org.reactivecommons.async.commons.DiscardNotifier;
import org.reactivecommons.async.commons.communications.Message;
import org.reactivecommons.async.commons.converters.MessageConverter;
import org.reactivecommons.async.commons.exceptions.MessageConversionException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DLQDiscardNotifier
implements DiscardNotifier {
    @Generated
    private static final Logger log = Logger.getLogger(DLQDiscardNotifier.class.getName());
    private final DomainEventBus eventBus;
    private final MessageConverter messageConverter;

    @Override
    public Mono<Void> notifyDiscard(Message message) {
        try {
            return this.notify(message).onErrorResume(this::onError);
        }
        catch (Exception e) {
            return this.onError(e);
        }
    }

    private Mono<Void> notify(Message message) {
        if (this.isCloudEvent(message)) {
            CloudEvent cloudEvent = this.messageConverter.readCloudEvent(message);
            String dlqType = cloudEvent.getType() + ".dlq";
            CloudEvent forDlq = CloudEventBuilder.from((CloudEvent)cloudEvent).withType(dlqType).build();
            return Mono.from((Publisher)this.eventBus.emit(forDlq));
        }
        try {
            JsonSkeleton node = this.messageConverter.readValue(message, JsonSkeleton.class);
            return Mono.from((Publisher)this.eventBus.emit(this.createEvent(node)));
        }
        catch (MessageConversionException e) {
            return this.notifyUnreadableMessage(message, e);
        }
    }

    private Mono<Void> notifyUnreadableMessage(Message message, MessageConversionException e) {
        Object bodyString;
        try {
            bodyString = new String(message.getBody());
        }
        catch (Exception ex) {
            bodyString = "Opaque binary Message, unable to decode: " + ex.getMessage();
        }
        log.log(Level.SEVERE, String.format("Unable to interpret discarded message: %s", bodyString), e);
        DomainEvent event = new DomainEvent("corruptData.dlq", "corruptData", bodyString);
        return Mono.from((Publisher)this.eventBus.emit(event));
    }

    private Mono<Void> onError(Throwable e) {
        log.log(Level.SEVERE, "FATAL!! unable to notify Discard of message!!", e);
        return Mono.empty();
    }

    private DomainEvent<JsonNode> createEvent(JsonSkeleton skeleton) {
        if (skeleton.isCommand()) {
            return new DomainEvent(skeleton.name + ".dlq", skeleton.commandId, (Object)skeleton.data);
        }
        if (skeleton.isEvent()) {
            return new DomainEvent(skeleton.name + ".dlq", skeleton.eventId, (Object)skeleton.data);
        }
        if (skeleton.isQuery()) {
            return new DomainEvent(skeleton.resource + ".dlq", skeleton.resource + "query", (Object)skeleton.queryData);
        }
        throw new MessageConversionException("Fail to math message type");
    }

    private boolean isCloudEvent(Message message) {
        return message.getProperties().getContentType() != null && message.getProperties().getContentType().contains("application/cloudevents+json");
    }

    @ConstructorProperties(value={"eventBus", "messageConverter"})
    @Generated
    public DLQDiscardNotifier(DomainEventBus eventBus, MessageConverter messageConverter) {
        this.eventBus = eventBus;
        this.messageConverter = messageConverter;
    }

    private static class JsonSkeleton {
        private String name;
        private String resource;
        private String eventId;
        private JsonNode data;
        private JsonNode queryData;
        private String commandId;

        public boolean isEvent() {
            return !this.empty(this.eventId) && !this.empty(this.name) && this.data != null;
        }

        public boolean isCommand() {
            return !this.empty(this.commandId) && !this.empty(this.name) && this.data != null;
        }

        public boolean isQuery() {
            return !this.empty(this.resource) && this.queryData != null;
        }

        private boolean empty(String str) {
            return str == null || str.trim().isEmpty();
        }

        @Generated
        public JsonSkeleton() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getResource() {
            return this.resource;
        }

        @Generated
        public String getEventId() {
            return this.eventId;
        }

        @Generated
        public JsonNode getData() {
            return this.data;
        }

        @Generated
        public JsonNode getQueryData() {
            return this.queryData;
        }

        @Generated
        public String getCommandId() {
            return this.commandId;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setResource(String resource) {
            this.resource = resource;
        }

        @Generated
        public void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Generated
        public void setData(JsonNode data) {
            this.data = data;
        }

        @Generated
        public void setQueryData(JsonNode queryData) {
            this.queryData = queryData;
        }

        @Generated
        public void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonSkeleton)) {
                return false;
            }
            JsonSkeleton other = (JsonSkeleton)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$resource = this.getResource();
            String other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
                return false;
            }
            String this$eventId = this.getEventId();
            String other$eventId = other.getEventId();
            if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
                return false;
            }
            JsonNode this$data = this.getData();
            JsonNode other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            JsonNode this$queryData = this.getQueryData();
            JsonNode other$queryData = other.getQueryData();
            if (this$queryData == null ? other$queryData != null : !this$queryData.equals(other$queryData)) {
                return false;
            }
            String this$commandId = this.getCommandId();
            String other$commandId = other.getCommandId();
            return !(this$commandId == null ? other$commandId != null : !this$commandId.equals(other$commandId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JsonSkeleton;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            String $eventId = this.getEventId();
            result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
            JsonNode $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            JsonNode $queryData = this.getQueryData();
            result = result * 59 + ($queryData == null ? 43 : $queryData.hashCode());
            String $commandId = this.getCommandId();
            result = result * 59 + ($commandId == null ? 43 : $commandId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DLQDiscardNotifier.JsonSkeleton(name=" + this.getName() + ", resource=" + this.getResource() + ", eventId=" + this.getEventId() + ", data=" + String.valueOf(this.getData()) + ", queryData=" + String.valueOf(this.getQueryData()) + ", commandId=" + this.getCommandId() + ")";
        }
    }
}

