/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.commons;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.async.api.handlers.registered.RegisteredCommandHandler;
import org.reactivecommons.async.api.handlers.registered.RegisteredEventListener;
import org.reactivecommons.async.api.handlers.registered.RegisteredQueryHandler;
import org.reactivecommons.async.commons.utils.matcher.KeyMatcher;
import org.reactivecommons.async.commons.utils.matcher.Matcher;

public class HandlerResolver {
    @Generated
    private static final Logger log = Logger.getLogger(HandlerResolver.class.getName());
    private final Map<String, RegisteredQueryHandler<?, ?>> queryHandlers;
    private final Map<String, RegisteredEventListener<?, ?>> eventListeners;
    private final Map<String, RegisteredEventListener<?, ?>> eventsToBind;
    private final Map<String, RegisteredEventListener<?, ?>> eventNotificationListeners;
    private final Map<String, RegisteredCommandHandler<?, ?>> commandHandlers;
    private final Matcher matcher = new KeyMatcher();

    public boolean hasNotificationListeners() {
        return !this.eventNotificationListeners.isEmpty();
    }

    public boolean hasCommandHandlers() {
        return !this.commandHandlers.isEmpty();
    }

    public boolean hasQueryHandlers() {
        return !this.queryHandlers.isEmpty();
    }

    public <T, M> RegisteredQueryHandler<T, M> getQueryHandler(String path) {
        return this.queryHandlers.computeIfAbsent(path, this.getMatchHandler(this.queryHandlers));
    }

    public <T, D> RegisteredCommandHandler<T, D> getCommandHandler(String path) {
        return this.commandHandlers.computeIfAbsent(path, this.getMatchHandler(this.commandHandlers));
    }

    public <T, D> RegisteredEventListener<T, D> getEventListener(String path) {
        if (this.eventListeners.containsKey(path)) {
            return this.eventListeners.get(path);
        }
        return this.getMatchHandler(this.eventListeners).apply(path);
    }

    public Collection<RegisteredEventListener<?, ?>> getNotificationListeners() {
        return this.eventNotificationListeners.values();
    }

    public <T, D> RegisteredEventListener<T, D> getNotificationListener(String path) {
        return this.eventNotificationListeners.computeIfAbsent(path, this.getMatchHandler(this.eventNotificationListeners));
    }

    public Collection<RegisteredEventListener<?, ?>> getEventListeners() {
        return this.eventsToBind.values();
    }

    public List<String> getEventNames() {
        return List.copyOf(this.eventListeners.keySet());
    }

    public List<String> getNotificationNames() {
        return List.copyOf(this.eventNotificationListeners.keySet());
    }

    public void addEventListener(RegisteredEventListener<?, ?> listener) {
        this.eventListeners.put(listener.getPath(), listener);
    }

    public void addQueryHandler(RegisteredQueryHandler<?, ?> handler) {
        if (handler.getPath().contains("*") || handler.getPath().contains("#")) {
            throw new RuntimeException("avoid * or # in dynamic handlers, make sure you have no conflicts with cached patterns");
        }
        this.queryHandlers.put(handler.getPath(), handler);
    }

    private <T> Function<String, T> getMatchHandler(Map<String, T> handlers) {
        return name -> handlers.get(this.matcher.match(handlers.keySet(), (String)name));
    }

    @ConstructorProperties(value={"queryHandlers", "eventListeners", "eventsToBind", "eventNotificationListeners", "commandHandlers"})
    @Generated
    public HandlerResolver(Map<String, RegisteredQueryHandler<?, ?>> queryHandlers, Map<String, RegisteredEventListener<?, ?>> eventListeners, Map<String, RegisteredEventListener<?, ?>> eventsToBind, Map<String, RegisteredEventListener<?, ?>> eventNotificationListeners, Map<String, RegisteredCommandHandler<?, ?>> commandHandlers) {
        this.queryHandlers = queryHandlers;
        this.eventListeners = eventListeners;
        this.eventsToBind = eventsToBind;
        this.eventNotificationListeners = eventNotificationListeners;
        this.commandHandlers = commandHandlers;
    }
}

