/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.commons.reply;

import java.util.concurrent.ConcurrentHashMap;
import org.reactivecommons.async.commons.communications.Message;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ReactiveReplyRouter {
    private final ConcurrentHashMap<String, Sinks.One<Message>> processors = new ConcurrentHashMap();

    public Mono<Message> register(String correlationID) {
        Sinks.One processor = Sinks.one();
        this.processors.put(correlationID, (Sinks.One<Message>)processor);
        return processor.asMono();
    }

    public void routeReply(String correlationID, Message data) {
        Sinks.One<Message> processor = this.processors.remove(correlationID);
        if (processor != null) {
            processor.tryEmitValue((Object)data);
        }
    }

    public void deregister(String correlationID) {
        this.processors.remove(correlationID);
    }

    public void routeEmpty(String correlationID) {
        Sinks.One<Message> processor = this.processors.remove(correlationID);
        if (processor != null) {
            processor.tryEmitEmpty();
        }
    }
}

