/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.commons.config;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.UUID;
import lombok.Generated;

public class BrokerConfig {
    private final String routingKey = UUID.randomUUID().toString().replace("-", "");
    private final boolean persistentQueries;
    private final boolean persistentCommands;
    private final boolean persistentEvents;
    private final Duration replyTimeout;

    public BrokerConfig() {
        this.persistentQueries = false;
        this.persistentCommands = true;
        this.persistentEvents = true;
        this.replyTimeout = Duration.ofSeconds(15L);
    }

    @Generated
    public String getRoutingKey() {
        return this.routingKey;
    }

    @Generated
    public boolean isPersistentQueries() {
        return this.persistentQueries;
    }

    @Generated
    public boolean isPersistentCommands() {
        return this.persistentCommands;
    }

    @Generated
    public boolean isPersistentEvents() {
        return this.persistentEvents;
    }

    @Generated
    public Duration getReplyTimeout() {
        return this.replyTimeout;
    }

    @ConstructorProperties(value={"persistentQueries", "persistentCommands", "persistentEvents", "replyTimeout"})
    @Generated
    public BrokerConfig(boolean persistentQueries, boolean persistentCommands, boolean persistentEvents, Duration replyTimeout) {
        this.persistentQueries = persistentQueries;
        this.persistentCommands = persistentCommands;
        this.persistentEvents = persistentEvents;
        this.replyTimeout = replyTimeout;
    }
}

