/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit;

import io.cloudevents.CloudEvent;
import java.util.Collections;
import org.reactivecommons.api.domain.DomainEvent;
import org.reactivecommons.api.domain.DomainEventBus;
import org.reactivecommons.api.domain.RawMessage;
import org.reactivecommons.async.commons.config.BrokerConfig;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageSender;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class RabbitDomainEventBus
implements DomainEventBus {
    private static final String EVENT_SEND_FAILURE = "Event send failure: ";
    private static final String NOT_IMPLEMENTED_YET = "Not implemented yet";
    private final ReactiveMessageSender sender;
    private final String exchange;
    private final boolean persistentEvents;

    public RabbitDomainEventBus(ReactiveMessageSender sender, String exchange) {
        this(sender, exchange, new BrokerConfig());
    }

    public RabbitDomainEventBus(ReactiveMessageSender sender, String exchange, BrokerConfig config) {
        this.sender = sender;
        this.exchange = exchange;
        this.persistentEvents = config.isPersistentEvents();
    }

    public <T> Mono<Void> emit(DomainEvent<T> event) {
        return this.sender.sendWithConfirm(event, this.exchange, event.getName(), Collections.emptyMap(), this.persistentEvents).onErrorMap(err -> new RuntimeException(EVENT_SEND_FAILURE + event.getName(), (Throwable)err));
    }

    public <T> Publisher<Void> emit(String domain, DomainEvent<T> event) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    public Publisher<Void> emit(CloudEvent cloudEvent) {
        return this.sender.sendWithConfirm(cloudEvent, this.exchange, cloudEvent.getType(), Collections.emptyMap(), this.persistentEvents).onErrorMap(err -> new RuntimeException(EVENT_SEND_FAILURE + cloudEvent.getType(), (Throwable)err));
    }

    public Publisher<Void> emit(String domain, CloudEvent event) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    public Publisher<Void> emit(RawMessage rawEvent) {
        return this.sender.sendWithConfirm(rawEvent, this.exchange, rawEvent.getType(), Collections.emptyMap(), this.persistentEvents).onErrorMap(err -> new RuntimeException(EVENT_SEND_FAILURE + rawEvent.getType(), (Throwable)err));
    }

    public Publisher<Void> emit(String domain, RawMessage event) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }
}

