/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit.communications;

import com.rabbitmq.client.AMQP;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Logger;
import lombok.Generated;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.Sender;

public class TopologyCreator {
    @Generated
    private static final Logger log = Logger.getLogger(TopologyCreator.class.getName());
    private final Sender sender;

    public TopologyCreator(Sender sender) {
        this.sender = sender;
    }

    public Mono<AMQP.Exchange.DeclareOk> declare(ExchangeSpecification exchange) {
        return this.sender.declare(exchange).onErrorMap(TopologyDefException::new);
    }

    public Mono<AMQP.Queue.DeclareOk> declare(QueueSpecification queue) {
        return this.sender.declare(queue).onErrorMap(TopologyDefException::new);
    }

    public Mono<AMQP.Queue.BindOk> bind(BindingSpecification binding) {
        return this.sender.bind(binding).onErrorMap(TopologyDefException::new);
    }

    public Mono<AMQP.Queue.UnbindOk> unbind(BindingSpecification binding) {
        return this.sender.unbind(binding).onErrorMap(TopologyDefException::new);
    }

    public Mono<AMQP.Queue.DeclareOk> declareDLQ(String originQueue, String retryTarget, int retryTime, Optional<Integer> maxLengthBytesOpt) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("x-dead-letter-exchange", retryTarget);
        args.put("x-message-ttl", retryTime);
        maxLengthBytesOpt.ifPresent(maxLengthBytes -> args.put("x-max-length-bytes", maxLengthBytes));
        QueueSpecification specification = QueueSpecification.queue((String)(originQueue + ".DLQ")).durable(true).arguments(args);
        return this.declare(specification);
    }

    public Mono<AMQP.Queue.DeclareOk> declareQueue(String name, String dlqExchange, Optional<Integer> maxLengthBytesOpt) {
        return this.declareQueue(name, dlqExchange, maxLengthBytesOpt, Optional.empty());
    }

    public Mono<AMQP.Queue.DeclareOk> declareQueue(String name, String dlqExchange, Optional<Integer> maxLengthBytesOpt, Optional<String> dlRoutingKey) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-dead-letter-exchange", dlqExchange);
        maxLengthBytesOpt.ifPresent(maxLengthBytes -> args.put("x-max-length-bytes", (String)maxLengthBytes));
        dlRoutingKey.ifPresent(routingKey -> args.put("x-dead-letter-routing-key", (String)routingKey));
        QueueSpecification specification = QueueSpecification.queue((String)name).durable(true).arguments(args);
        return this.declare(specification);
    }

    public Mono<AMQP.Queue.DeclareOk> declareQueue(String name, Optional<Integer> maxLengthBytesOpt) {
        QueueSpecification specification = QueueSpecification.queue((String)name).durable(true);
        if (maxLengthBytesOpt.isPresent()) {
            HashMap<String, Integer> args = new HashMap<String, Integer>();
            args.put("x-max-length-bytes", maxLengthBytesOpt.orElse(0));
            specification = specification.arguments(args);
        }
        return this.declare(specification);
    }

    public static class TopologyDefException
    extends RuntimeException {
        public TopologyDefException(Throwable cause) {
            super(cause);
        }
    }
}

