/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit.listeners;

import com.rabbitmq.client.AMQP;
import java.util.function.Function;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.async.api.handlers.CloudEventHandler;
import org.reactivecommons.async.api.handlers.DomainEventHandler;
import org.reactivecommons.async.api.handlers.registered.RegisteredEventListener;
import org.reactivecommons.async.commons.DiscardNotifier;
import org.reactivecommons.async.commons.EventExecutor;
import org.reactivecommons.async.commons.HandlerResolver;
import org.reactivecommons.async.commons.communications.Message;
import org.reactivecommons.async.commons.converters.MessageConverter;
import org.reactivecommons.async.commons.ext.CustomReporter;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageListener;
import org.reactivecommons.async.rabbit.communications.TopologyCreator;
import org.reactivecommons.async.rabbit.listeners.GenericMessageListener;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.AcknowledgableDelivery;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;
import reactor.rabbitmq.QueueSpecification;

public class ApplicationNotificationListener
extends GenericMessageListener {
    @Generated
    private static final Logger log = Logger.getLogger(ApplicationNotificationListener.class.getName());
    private final MessageConverter messageConverter;
    private final HandlerResolver resolver;
    private final String exchangeName;
    private final boolean createTopology;

    public ApplicationNotificationListener(ReactiveMessageListener receiver, String exchangeName, String queueName, boolean createTopology, HandlerResolver handlerResolver, MessageConverter messageConverter, DiscardNotifier discardNotifier, CustomReporter errorReporter) {
        super(queueName, receiver, false, true, 1L, 200L, discardNotifier, "event", errorReporter);
        this.resolver = handlerResolver;
        this.messageConverter = messageConverter;
        this.exchangeName = exchangeName;
        this.createTopology = createTopology;
    }

    @Override
    protected Mono<Void> setUpBindings(TopologyCreator creator) {
        Mono<AMQP.Queue.DeclareOk> declareQueue = creator.declare(QueueSpecification.queue((String)this.queueName).durable(false).autoDelete(true).exclusive(true));
        Flux bindings = Flux.fromIterable((Iterable)this.resolver.getNotificationListeners()).flatMap(listener -> creator.bind(BindingSpecification.binding((String)this.exchangeName, (String)listener.getPath(), (String)this.queueName)));
        if (this.createTopology) {
            return creator.declare(ExchangeSpecification.exchange((String)this.exchangeName).type("topic").durable(true)).then(declareQueue).thenMany((Publisher)bindings).then();
        }
        return declareQueue.thenMany((Publisher)bindings).then();
    }

    @Override
    protected Function<Message, Mono<Object>> rawMessageHandler(String executorPath) {
        RegisteredEventListener eventListener = this.resolver.getNotificationListener(executorPath);
        Function<Message, Object> converter = this.resolveConverter(eventListener);
        EventExecutor executor = new EventExecutor(eventListener.getHandler(), converter);
        return message -> executor.execute(message).cast(Object.class);
    }

    @Override
    protected String getExecutorPath(AcknowledgableDelivery message) {
        return message.getEnvelope().getRoutingKey();
    }

    @Override
    protected Object parseMessageForReporter(Message msj) {
        return this.messageConverter.readDomainEventStructure(msj);
    }

    private <T, D> Function<Message, Object> resolveConverter(RegisteredEventListener<T, D> registeredEventListener) {
        if (registeredEventListener.getHandler() instanceof DomainEventHandler) {
            Class eventClass = registeredEventListener.getInputClass();
            return msj -> this.messageConverter.readDomainEvent(msj, eventClass);
        }
        if (registeredEventListener.getHandler() instanceof CloudEventHandler) {
            return arg_0 -> ((MessageConverter)this.messageConverter).readCloudEvent(arg_0);
        }
        throw new RuntimeException("Unknown handler type");
    }
}

