package reactivemongo.api.gridfs

private[gridfs] trait GridFSCompat {

  /* Concats two array - fast way */
  protected def concat[T](
      a1: Array[T],
      a2: Array[T]
    )(implicit
      m: scala.reflect.ClassTag[T]
    ): Array[T] = {
    var i, j = 0
    val result = new Array[T](a1.length + a2.length)
    while (i < a1.length) {
      result(i) = a1(i)
      i = i + 1
    }
    while (j < a2.length) {
      result(i + j) = a2(j)
      j = j + 1
    }
    result
  }
}
