/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types.control;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.AmqpCapabilities;
import org.reaktivity.specification.amqp.internal.types.AmqpCapabilitiesFW;
import org.reaktivity.specification.amqp.internal.types.ArrayFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;
import org.reaktivity.specification.amqp.internal.types.String8FW;

public final class AmqpRouteExFW
extends Flyweight {
    public static final int FIELD_OFFSET_ADDRESS = 0;
    public static final int FIELD_OFFSET_CAPABILITIES = 0;
    private final String8FW addressRO = new String8FW();
    private AmqpCapabilitiesFW capabilitiesRO = new AmqpCapabilitiesFW();

    public String8FW address() {
        return this.addressRO;
    }

    public AmqpCapabilitiesFW capabilities() {
        return this.capabilitiesRO;
    }

    @Override
    public AmqpRouteExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.addressRO.wrap(buffer, offset + 0, maxLimit);
        this.capabilitiesRO.wrap(buffer, this.addressRO.limit() + 0, maxLimit);
        AmqpRouteExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public AmqpRouteExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.addressRO.tryWrap(buffer, offset + 0, maxLimit)) {
            return null;
        }
        if (null == this.capabilitiesRO.tryWrap(buffer, this.addressRO.limit() + 0, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.capabilitiesRO.limit();
    }

    public String toString() {
        return String.format("AMQP_ROUTE_EX [address=%s, capabilities=%s]", this.addressRO.asString(), this.capabilities());
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpRouteExFW> {
        private static final int INDEX_ADDRESS = 0;
        private static final int INDEX_CAPABILITIES = 1;
        public static final AmqpCapabilities DEFAULT_CAPABILITIES = AmqpCapabilities.SEND_AND_RECEIVE;
        private static final int FIELD_COUNT = 2;
        private final String8FW.Builder addressRW = new String8FW.Builder();
        private final AmqpCapabilitiesFW.Builder capabilitiesRW = new AmqpCapabilitiesFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new AmqpRouteExFW());
        }

        private String8FW.Builder address() {
            assert (this.lastFieldSet == -1);
            return this.addressRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder address(String value) {
            String8FW.Builder addressRW = this.address();
            addressRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 0;
            this.limit(addressRW.build().limit());
            return this;
        }

        public Builder address(String8FW value) {
            String8FW.Builder addressRW = this.address();
            addressRW.set(value);
            this.lastFieldSet = 0;
            this.limit(addressRW.build().limit());
            return this;
        }

        public Builder address(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder addressRW = this.address();
            addressRW.set(buffer, offset, length);
            this.lastFieldSet = 0;
            this.limit(addressRW.build().limit());
            return this;
        }

        public Builder capabilities(Consumer<AmqpCapabilitiesFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            AmqpCapabilitiesFW.Builder capabilitiesRW = this.capabilitiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(capabilitiesRW);
            this.limit(capabilitiesRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder capabilities(AmqpCapabilitiesFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            AmqpRouteExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<AmqpRouteExFW>, ? extends Flyweight.Builder<AmqpRouteExFW>, AmqpRouteExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public AmqpRouteExFW build() {
            if (this.lastFieldSet < 1) {
                this.capabilities((AmqpCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (AmqpRouteExFW)super.build();
        }
    }
}

