/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types.stream;

import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.ArrayFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;
import org.reaktivity.specification.amqp.internal.types.String8FW;

public final class AmqpAbortExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_CONDITION = 4;
    private final String8FW conditionRO = new String8FW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public String8FW condition() {
        return this.conditionRO;
    }

    @Override
    public AmqpAbortExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.conditionRO.wrap(buffer, offset + 4, maxLimit);
        AmqpAbortExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public AmqpAbortExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.conditionRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.conditionRO.limit();
    }

    public String toString() {
        return String.format("AMQP_ABORT_EX [typeId=%d, condition=%s]", this.typeId(), this.conditionRO.asString());
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpAbortExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_CONDITION = 1;
        private static final int FIELD_COUNT = 2;
        private final String8FW.Builder conditionRW = new String8FW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new AmqpAbortExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            AmqpAbortExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        private String8FW.Builder condition() {
            assert (this.lastFieldSet == 0);
            return this.conditionRW.wrap(this.buffer(), this.limit(), this.maxLimit());
        }

        public Builder condition(String value) {
            String8FW.Builder conditionRW = this.condition();
            conditionRW.set(value, StandardCharsets.UTF_8);
            this.lastFieldSet = 1;
            this.limit(conditionRW.build().limit());
            return this;
        }

        public Builder condition(String8FW value) {
            String8FW.Builder conditionRW = this.condition();
            conditionRW.set(value);
            this.lastFieldSet = 1;
            this.limit(conditionRW.build().limit());
            return this;
        }

        public Builder condition(DirectBuffer buffer, int offset, int length) {
            String8FW.Builder conditionRW = this.condition();
            conditionRW.set(buffer, offset, length);
            this.lastFieldSet = 1;
            this.limit(conditionRW.build().limit());
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<AmqpAbortExFW>, ? extends Flyweight.Builder<AmqpAbortExFW>, AmqpAbortExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public AmqpAbortExFW build() {
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (AmqpAbortExFW)super.build();
        }
    }
}

