/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types.stream;

import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.AmqpCapabilities;
import org.reaktivity.specification.amqp.internal.types.AmqpCapabilitiesFW;
import org.reaktivity.specification.amqp.internal.types.ArrayFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;

public final class AmqpFlushExFW
extends Flyweight {
    public static final int FIELD_OFFSET_TYPE_ID = 0;
    private static final int FIELD_SIZE_TYPE_ID = 4;
    public static final int FIELD_OFFSET_CAPABILITIES = 4;
    private AmqpCapabilitiesFW capabilitiesRO = new AmqpCapabilitiesFW();

    public int typeId() {
        return this.buffer().getInt(this.offset() + 0);
    }

    public AmqpCapabilitiesFW capabilities() {
        return this.capabilitiesRO;
    }

    @Override
    public AmqpFlushExFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.capabilitiesRO.wrap(buffer, offset + 4, maxLimit);
        AmqpFlushExFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public AmqpFlushExFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (null == super.tryWrap(buffer, offset, maxLimit)) {
            return null;
        }
        if (null == this.capabilitiesRO.tryWrap(buffer, offset + 4, maxLimit)) {
            return null;
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public int limit() {
        return this.capabilitiesRO.limit();
    }

    public String toString() {
        return String.format("AMQP_FLUSH_EX [typeId=%d, capabilities=%s]", this.typeId(), this.capabilities());
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpFlushExFW> {
        private static final int INDEX_TYPE_ID = 0;
        private static final int INDEX_CAPABILITIES = 1;
        public static final AmqpCapabilities DEFAULT_CAPABILITIES = AmqpCapabilities.SEND_AND_RECEIVE;
        private static final int FIELD_COUNT = 2;
        private final AmqpCapabilitiesFW.Builder capabilitiesRW = new AmqpCapabilitiesFW.Builder();
        private int lastFieldSet = -1;

        public Builder() {
            super(new AmqpFlushExFW());
        }

        public Builder typeId(int value) {
            assert (this.lastFieldSet == -1);
            int newLimit = this.limit() + 4;
            AmqpFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putInt(this.limit(), value);
            this.lastFieldSet = 0;
            this.limit(newLimit);
            return this;
        }

        public Builder capabilities(Consumer<AmqpCapabilitiesFW.Builder> mutator) {
            assert (this.lastFieldSet == 0);
            AmqpCapabilitiesFW.Builder capabilitiesRW = this.capabilitiesRW.wrap(this.buffer(), this.limit(), this.maxLimit());
            mutator.accept(capabilitiesRW);
            this.limit(capabilitiesRW.build().limit());
            this.lastFieldSet = 1;
            return this;
        }

        public Builder capabilities(AmqpCapabilitiesFW field) {
            assert (this.lastFieldSet == 0);
            int newLimit = this.limit() + field.sizeof();
            AmqpFlushExFW.checkLimit(newLimit, this.maxLimit());
            this.buffer().putBytes(this.limit(), field.buffer(), field.offset(), field.sizeof());
            this.limit(newLimit);
            this.lastFieldSet = 1;
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            this.lastFieldSet = -1;
            this.limit(offset);
            return this;
        }

        public Builder wrap(ArrayFW.Builder<? extends ArrayFW<AmqpFlushExFW>, ? extends Flyweight.Builder<AmqpFlushExFW>, AmqpFlushExFW> array) {
            super.wrap(array);
            this.lastFieldSet = -1;
            return this;
        }

        public Builder rewrap() {
            super.rewrap();
            return this;
        }

        @Override
        public AmqpFlushExFW build() {
            if (this.lastFieldSet < 1) {
                this.capabilities((AmqpCapabilitiesFW.Builder b) -> b.set(DEFAULT_CAPABILITIES));
            }
            assert (this.lastFieldSet == 1);
            this.lastFieldSet = -1;
            return (AmqpFlushExFW)super.build();
        }
    }
}

