/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.reaktivity.specification.amqp.internal.types.AmqpBinaryFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;
import org.reaktivity.specification.amqp.internal.types.String8FW;
import org.reaktivity.specification.amqp.internal.types.StringFW;

public final class AmqpMessageIdFW
extends Flyweight {
    private static final int FIELD_SIZE_KIND = 1;
    private static final int FIELD_OFFSET_KIND = 0;
    public static final int KIND_ULONG = 1;
    public static final int FIELD_OFFSET_ULONG = 1;
    private static final int FIELD_SIZE_ULONG = 8;
    public static final int KIND_UUID = 2;
    public static final int FIELD_OFFSET_UUID = 1;
    public static final int KIND_BINARY = 3;
    public static final int FIELD_OFFSET_BINARY = 1;
    public static final int KIND_STRINGTYPE = 4;
    public static final int FIELD_OFFSET_STRINGTYPE = 1;
    private final AmqpBinaryFW uuidRO = new AmqpBinaryFW();
    private final AmqpBinaryFW binaryRO = new AmqpBinaryFW();
    private final String8FW stringtypeRO = new String8FW();

    public int kind() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    public long ulong() {
        return this.buffer().getLong(this.offset() + 1);
    }

    public AmqpBinaryFW uuid() {
        return this.uuidRO;
    }

    public AmqpBinaryFW binary() {
        return this.binaryRO;
    }

    public String8FW stringtype() {
        return this.stringtypeRO;
    }

    @Override
    public AmqpMessageIdFW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        switch (this.kind()) {
            case 1: {
                break;
            }
            case 2: {
                if (this.uuidRO.tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
            case 3: {
                if (this.binaryRO.tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
            case 4: {
                if (this.stringtypeRO.tryWrap(buffer, offset + 1, maxLimit) != null) break;
                return null;
            }
        }
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public AmqpMessageIdFW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        switch (this.kind()) {
            case 1: {
                break;
            }
            case 2: {
                this.uuidRO.wrap(buffer, offset + 1, maxLimit);
                break;
            }
            case 3: {
                this.binaryRO.wrap(buffer, offset + 1, maxLimit);
                break;
            }
            case 4: {
                this.stringtypeRO.wrap(buffer, offset + 1, maxLimit);
                break;
            }
        }
        AmqpMessageIdFW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        switch (this.kind()) {
            case 1: {
                return this.offset() + 1 + 8;
            }
            case 2: {
                return this.uuid().limit();
            }
            case 3: {
                return this.binary().limit();
            }
            case 4: {
                return this.stringtype().limit();
            }
        }
        return this.offset();
    }

    public String toString() {
        switch (this.kind()) {
            case 1: {
                return String.format("AMQP_MESSAGE_ID [ulong=%d]", this.ulong());
            }
            case 2: {
                return String.format("AMQP_MESSAGE_ID [uuid=%s]", this.uuid());
            }
            case 3: {
                return String.format("AMQP_MESSAGE_ID [binary=%s]", this.binary());
            }
            case 4: {
                return String.format("AMQP_MESSAGE_ID [stringtype=%s]", this.stringtype());
            }
        }
        return String.format("AMQP_MESSAGE_ID [unknown]", new Object[0]);
    }

    public static final class Builder
    extends Flyweight.Builder<AmqpMessageIdFW> {
        private final AmqpBinaryFW.Builder uuidRW = new AmqpBinaryFW.Builder();
        private final AmqpBinaryFW.Builder binaryRW = new AmqpBinaryFW.Builder();
        private final String8FW.Builder stringtypeRW = new String8FW.Builder();

        public Builder() {
            super(new AmqpMessageIdFW());
        }

        public Builder kind(int value) {
            this.buffer().putByte(this.offset() + 0, (byte)(value & 0xFF));
            return this;
        }

        public Builder ulong(long value) {
            this.kind(1);
            this.buffer().putLong(this.offset() + 1, value);
            this.limit(this.offset() + 1 + 8);
            return this;
        }

        private AmqpBinaryFW.Builder uuid() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.uuidRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder uuid(Consumer<AmqpBinaryFW.Builder> mutator) {
            this.kind(2);
            AmqpBinaryFW.Builder uuid = this.uuid();
            mutator.accept(uuid);
            this.limit(uuid.build().limit());
            return this;
        }

        private AmqpBinaryFW.Builder binary() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.binaryRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder binary(Consumer<AmqpBinaryFW.Builder> mutator) {
            this.kind(3);
            AmqpBinaryFW.Builder binary = this.binary();
            mutator.accept(binary);
            this.limit(binary.build().limit());
            return this;
        }

        private String8FW.Builder stringtype() {
            int newLimit = this.maxLimit();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            return this.stringtypeRW.wrap(this.buffer(), this.offset() + 1, newLimit);
        }

        public Builder stringtype(String value) {
            if (value == null) {
                this.limit(this.offset() + 1);
            } else {
                this.kind(4);
                String8FW.Builder stringtype = this.stringtype();
                stringtype.set(value, StandardCharsets.UTF_8);
                this.limit(stringtype.build().limit());
            }
            return this;
        }

        public Builder stringtype(StringFW value) {
            if (value == null) {
                this.limit(this.offset() + 1);
            } else {
                this.kind(4);
                String8FW.Builder stringtype = this.stringtype();
                stringtype.set(value);
                this.limit(stringtype.build().limit());
            }
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

