/*
 * Decompiled with CFR 0.152.
 */
package org.reaktivity.specification.amqp.internal.types;

import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.reaktivity.specification.amqp.internal.types.BoundedOctetsFW;
import org.reaktivity.specification.amqp.internal.types.Flyweight;

public final class BoundedOctets8FW
extends BoundedOctetsFW {
    private static final int LENGTH_SIZE = 1;
    private static final int LENGTH_OFFSET = 0;
    private static final int VALUE_OFFSET = 1;
    private final DirectBuffer valueRO = new UnsafeBuffer(0L, 0);

    @Override
    public <T> T get(Flyweight.Visitor<T> visitor) {
        return visitor.visit(this.buffer(), this.offset() + 1, this.limit());
    }

    @Override
    public DirectBuffer value() {
        return this.valueRO;
    }

    @Override
    public int length() {
        return this.buffer().getByte(this.offset() + 0) & 0xFF;
    }

    @Override
    public BoundedOctets8FW tryWrap(DirectBuffer buffer, int offset, int maxLimit) {
        if (super.tryWrap(buffer, offset, maxLimit) == null) {
            return null;
        }
        this.valueRO.wrap(buffer, offset + 1, this.length());
        if (this.limit() > maxLimit) {
            return null;
        }
        return this;
    }

    @Override
    public BoundedOctets8FW wrap(DirectBuffer buffer, int offset, int maxLimit) {
        super.wrap(buffer, offset, maxLimit);
        this.valueRO.wrap(buffer, offset + 1, this.length());
        BoundedOctets8FW.checkLimit(this.limit(), maxLimit);
        return this;
    }

    @Override
    public int limit() {
        return this.offset() + 1 + this.length();
    }

    public String toString() {
        return String.format("boundedOctets8[%d]", this.length());
    }

    public static final class Builder
    extends BoundedOctetsFW.Builder<BoundedOctets8FW> {
        public Builder() {
            super(new BoundedOctets8FW());
        }

        public Builder set(BoundedOctetsFW value) {
            int newLimit = this.offset() + 1 + value.length();
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.offset() + 0, (byte)(value.length() & 0xFF));
            this.buffer().putBytes(this.offset() + 1, value.buffer(), value.offset() + 1, value.length());
            this.limit(newLimit);
            return this;
        }

        public Builder set(DirectBuffer value, int offset, int length) {
            int newLimit = this.offset() + 1 + length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.offset() + 0, (byte)(length & 0xFF));
            this.buffer().putBytes(this.offset() + 1, value, offset, length);
            this.limit(newLimit);
            return this;
        }

        public Builder set(byte[] value) {
            int newLimit = this.offset() + 1 + value.length;
            Flyweight.checkLimit(newLimit, this.maxLimit());
            this.buffer().putByte(this.offset() + 0, (byte)(value.length & 0xFF));
            this.buffer().putBytes(this.offset() + 1, value);
            this.limit(newLimit);
            return this;
        }

        public Builder wrap(MutableDirectBuffer buffer, int offset, int maxLimit) {
            Flyweight.checkLimit(offset + 1, maxLimit);
            super.wrap(buffer, offset, maxLimit);
            return this;
        }
    }
}

